/*
 * Decompiled with CFR 0.152.
 */
package com.guardanis.imageloader.processors;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import com.guardanis.imageloader.ImageRequest;
import com.guardanis.imageloader.ImageUtils;
import com.guardanis.imageloader.filters.ImageFilter;
import java.io.File;
import java.util.List;

public abstract class ImageProcessor {
    public abstract Drawable process(ImageRequest var1, List<ImageFilter<Bitmap>> var2) throws Exception;

    protected Drawable process(Context context, Bitmap bitmap, File targetSaveFile, List<ImageFilter<Bitmap>> bitmapImageFilters) {
        Bitmap edited = this.applyFilters(context, bitmap, bitmapImageFilters);
        if (edited != null && 0 < bitmapImageFilters.size()) {
            ImageUtils.saveBitmapAsync(context, targetSaveFile, edited);
        }
        return new BitmapDrawable(context.getResources(), edited);
    }

    protected Bitmap decodeBitmap(File file, int requiredImageWidth) {
        return ImageUtils.decodeFile(file, requiredImageWidth);
    }

    protected BitmapDrawable decodeBitmapDrawable(Context context, File file, int requiredImageWidth) {
        return new BitmapDrawable(context.getResources(), this.decodeBitmap(file, requiredImageWidth));
    }

    protected Bitmap applyFilters(Context context, Bitmap bitmap, List<ImageFilter<Bitmap>> bitmapImageFilters) {
        if (0 < bitmapImageFilters.size() && bitmap != null) {
            try {
                for (ImageFilter<Bitmap> filter : bitmapImageFilters) {
                    bitmap = filter.filter(bitmap);
                }
            }
            catch (Throwable e) {
                ImageUtils.log(context, e);
                bitmap = null;
            }
        }
        return bitmap;
    }
}

