/*
 * Decompiled with CFR 0.152.
 */
package com.guardanis.imageloader.transitions.modules;

import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.support.annotation.Nullable;
import android.view.animation.Interpolator;
import com.guardanis.imageloader.transitions.drawables.TransitionDrawable;
import java.util.HashMap;
import java.util.Map;

public abstract class TransitionModule {
    public static final int INTERPOLATOR_IN = 0;
    public static final int INTERPOLATOR_OUT = 1;
    protected long duration;
    protected Map<Integer, Interpolator> interpolators = new HashMap<Integer, Interpolator>();

    public TransitionModule(long duration) {
        this.duration = duration;
    }

    public TransitionModule registerInterpolator(int id, Interpolator interpolator) {
        this.interpolators.put(id, interpolator);
        return this;
    }

    public Interpolator getInterpolator(int id) {
        return this.interpolators.get(id);
    }

    public abstract void onStart(@Nullable Drawable var1, Drawable var2);

    public abstract void onPredrawOld(TransitionDrawable var1, Canvas var2, @Nullable Drawable var3, long var4);

    public abstract void revertPostDrawOld(TransitionDrawable var1, @Nullable Drawable var2);

    public abstract void onPredrawTarget(TransitionDrawable var1, Canvas var2, Drawable var3, long var4);

    public abstract void revertPostDrawTarget(TransitionDrawable var1, Drawable var2);

    protected float calculatePercentCompleted(long startTimeMs) {
        return Math.min(1.0f, (float)(System.currentTimeMillis() - startTimeMs) / (float)this.duration);
    }

    protected float interpolate(int id, long startTimeMs) {
        return this.interpolate(id, this.calculatePercentCompleted(startTimeMs));
    }

    protected float interpolate(int id, float percentCompleted) {
        return this.interpolators.get(id) == null ? 1.0f : this.interpolators.get(id).getInterpolation(percentCompleted);
    }

    public long getDuration() {
        return this.duration;
    }
}

