/*
 * Decompiled with CFR 0.152.
 */
package com.guardanis.imageloader.filters;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import com.guardanis.imageloader.filters.ImageFilter;

public class BitmapColorFilter
extends ImageFilter<Bitmap> {
    private ColorFilter filter;

    public BitmapColorFilter(Context context, ColorFilter filter) {
        super(context);
        this.filter = filter;
    }

    @Override
    public Bitmap filter(Bitmap unedited) {
        if (unedited != null) {
            Bitmap adjusted = Bitmap.createBitmap((int)unedited.getWidth(), (int)unedited.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Paint paint = new Paint();
            paint.setColorFilter(this.filter);
            Canvas canvas = new Canvas(unedited);
            canvas.drawBitmap(adjusted, 0.0f, 0.0f, paint);
        }
        return unedited;
    }

    @Override
    public String getAdjustmentInfo() {
        return this.getClass().getSimpleName() + "_" + this.filter.getClass().getSimpleName();
    }
}

