/*
 * Decompiled with CFR 0.152.
 */
package com.guardanis.imageloader;

import android.content.Context;
import android.os.Environment;
import android.support.v4.content.ContextCompat;
import com.guardanis.imageloader.R;
import java.io.File;

public class FileCache {
    private Context context;
    private File cacheDir;
    private boolean externalStorageEnabled;
    private boolean targetStorageExternal = false;

    public FileCache(Context context) {
        this.context = context.getApplicationContext();
        this.externalStorageEnabled = context.getResources().getBoolean(R.bool.ail__external_storage_enabled);
    }

    private void ensureCacheDirectoryValid() {
        if (this.cacheDir == null || this.targetStorageExternal && ContextCompat.checkSelfPermission((Context)this.context, (String)"android.permission.WRITE_EXTERNAL_STORAGE") != 0) {
            this.updateCacheDirectory();
        }
    }

    private void updateCacheDirectory() {
        if (this.externalStorageEnabled && ContextCompat.checkSelfPermission((Context)this.context, (String)"android.permission.WRITE_EXTERNAL_STORAGE") == 0 && Environment.getExternalStorageState().equals("mounted")) {
            this.cacheDir = new File(Environment.getExternalStorageDirectory(), this.context.getPackageName());
            this.targetStorageExternal = true;
        } else {
            this.cacheDir = this.context.getResources().getBoolean(R.bool.ail__use_cache_dir) ? this.context.getCacheDir() : this.context.getFilesDir();
            this.targetStorageExternal = false;
        }
        if (!this.cacheDir.exists()) {
            this.cacheDir.mkdirs();
        }
    }

    public File getFile(String url) {
        this.ensureCacheDirectoryValid();
        String filename = String.valueOf(url.hashCode()) + (url.endsWith("svg") ? ".svg" : "");
        return new File(this.cacheDir, filename);
    }

    public void clear() {
        this.ensureCacheDirectoryValid();
        File[] files = this.cacheDir.listFiles();
        if (files != null) {
            for (File file : files) {
                file.delete();
            }
        }
    }

    public static void clear(Context context) {
        new FileCache(context).clear();
    }

    public boolean isCachedFileValid(String url, long maxCacheDurationMs) {
        return maxCacheDurationMs < 0L || System.currentTimeMillis() - this.getLastModifiedAt(url) < maxCacheDurationMs;
    }

    public long getLastModifiedAt(String url) {
        return this.getFile(url).lastModified();
    }

    public void delete(String url) {
        this.getFile(url).delete();
    }
}

