/*
 * Decompiled with CFR 0.152.
 */
package com.guardanis.imageloader;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Looper;
import android.support.v4.content.ContextCompat;
import android.view.View;
import com.guardanis.imageloader.FileCache;
import com.guardanis.imageloader.ImageDownloader;
import com.guardanis.imageloader.ImageRequest;
import com.guardanis.imageloader.ImageUtils;
import com.guardanis.imageloader.R;
import com.guardanis.imageloader.StubHolder;
import com.guardanis.imageloader.stubs.DefaultLoadingDrawable;
import java.io.File;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ImageLoader
implements ImageDownloader.DownloadEventListener {
    private static ImageLoader instance = null;
    private static final String PREFS = "ImageLoaderPrefs";
    protected Context context;
    protected FileCache fileCache;
    protected Map<View, String> views = Collections.synchronizedMap(new WeakHashMap());
    protected Map<String, ImageDownloader> downloadRequests = new HashMap<String, ImageDownloader>();
    protected Map<String, List<ImageRequest>> delayedRequests = new HashMap<String, List<ImageRequest>>();
    protected ExecutorService executorService;
    private StubHolder stubHolder;
    private final Handler handler = new Handler(Looper.getMainLooper());
    private final StubHolder defaultStubHolder = new StubHolder(){

        @Override
        public Drawable getLoadingDrawable(Context context) {
            return new DefaultLoadingDrawable(context.getResources());
        }

        @Override
        public Drawable getErrorDrawable(Context context) {
            return ContextCompat.getDrawable((Context)context, (int)R.drawable.ail__image_loader_stub_error);
        }
    };
    private final StubHolder defaultResourceStubHolder = new StubHolder(){

        @Override
        public Drawable getLoadingDrawable(Context context) {
            return ContextCompat.getDrawable((Context)context, (int)R.drawable.ail__image_loader_stub);
        }

        @Override
        public Drawable getErrorDrawable(Context context) {
            return ContextCompat.getDrawable((Context)context, (int)R.drawable.ail__image_loader_stub_error);
        }
    };

    public static synchronized ImageLoader getInstance(Context context) {
        if (instance == null) {
            instance = new ImageLoader(context);
        }
        return instance;
    }

    protected ImageLoader(Context context) {
        this.context = context.getApplicationContext();
        this.fileCache = new FileCache(context);
        this.executorService = Executors.newFixedThreadPool(context.getResources().getInteger(R.integer.ail__thread_pool_size));
    }

    public void submit(ImageRequest request) {
        if (request.isTargetLocal() || this.isImageDownloaded(request) && this.fileCache.isCachedFileValid(request.getTargetUrl(), request.getMaxCacheDurationMs())) {
            this.executorService.submit(request);
        } else {
            this.submitDownloadRequest(request);
        }
    }

    protected void submitDownloadRequest(ImageRequest request) {
        if (this.delayedRequests.get(request.getTargetUrl()) == null) {
            this.delayedRequests.put(request.getTargetUrl(), new ArrayList());
        }
        this.delayedRequests.get(request.getTargetUrl()).add(request);
        this.context.getSharedPreferences(PREFS, 0).edit().putBoolean(request.getTargetUrl(), false).commit();
        if (this.downloadRequests.get(request.getTargetUrl()) == null) {
            ImageDownloader downloadRequest = new ImageDownloader(this.handler, request, this);
            this.downloadRequests.put(request.getTargetUrl(), downloadRequest);
            this.executorService.submit(downloadRequest);
        }
    }

    @Override
    public synchronized void onDownloadCompleted(ImageDownloader downloadRequest, String targetUrl) {
        this.context.getSharedPreferences(PREFS, 0).edit().putBoolean(targetUrl, true).commit();
        if (this.delayedRequests.get(targetUrl) != null) {
            for (ImageRequest request : this.delayedRequests.get(targetUrl)) {
                this.executorService.submit(request);
            }
            this.delayedRequests.remove(targetUrl);
        }
        this.downloadRequests.remove(targetUrl);
    }

    @Override
    public synchronized void onDownloadFailed(ImageDownloader downloadRequest, String targetUrl) {
        if (this.delayedRequests.get(targetUrl) != null) {
            for (ImageRequest request : this.delayedRequests.get(targetUrl)) {
                this.executorService.submit(request);
            }
            this.delayedRequests.remove(targetUrl);
        }
        this.downloadRequests.remove(targetUrl);
    }

    public File download(ImageRequest request) {
        try {
            HttpURLConnection conn = this.openImageDownloadConnection(this.getCorrectDownloadUrl(request.getTargetUrl()));
            this.setHttpRequestProperties(request, conn);
            return this.download(conn, request.getOriginalRequestFile());
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Deprecated
    public File download(String url, File file) {
        try {
            return this.download(this.openImageDownloadConnection(this.getCorrectDownloadUrl(url)), file);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File download(HttpURLConnection conn, File file) {
        InputStream is = null;
        try {
            is = conn.getInputStream();
            ImageUtils.saveStream(file, is);
            File file2 = file;
            return file2;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        finally {
            ImageLoader.closeConnection(is);
        }
        return null;
    }

    protected URL getCorrectDownloadUrl(String url) throws Exception {
        URL imageUrl = new URL(url);
        for (String regex : Arrays.asList(this.context.getResources().getStringArray(R.array.ail__known_location_redirects_regex))) {
            Matcher matcher = Pattern.compile(regex).matcher(url);
            if (!matcher.find()) continue;
            return this.getAdjustedLocationImageUrl(imageUrl);
        }
        return imageUrl;
    }

    protected URL getAdjustedLocationImageUrl(URL imageUrl) throws Exception {
        HttpURLConnection.setFollowRedirects(false);
        HttpURLConnection conn = (HttpURLConnection)imageUrl.openConnection();
        URL adjustedImageUrl = new URL(conn.getHeaderField("Location"));
        conn.disconnect();
        HttpURLConnection.setFollowRedirects(true);
        return adjustedImageUrl;
    }

    protected HttpURLConnection openImageDownloadConnection(URL url) throws Exception {
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setConnectTimeout(30000);
        conn.setReadTimeout(30000);
        conn.setInstanceFollowRedirects(true);
        return conn;
    }

    protected void setHttpRequestProperties(ImageRequest request, HttpURLConnection conn) {
        Map<String, String> requestParams = request.getHttpRequestParams();
        for (String key : requestParams.keySet()) {
            conn.setRequestProperty(key, requestParams.get(key));
        }
    }

    public static void closeConnection(InputStream is) {
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void claimViewTarget(ImageRequest request) {
        this.claimViewTarget((View)request.getTargetView(), request.getTargetUrl(), request.getStartedAtMs());
    }

    private void claimViewTarget(View view, String targetUrl, long startedAtMs) {
        this.views.put(view, this.combineViewNameParams(targetUrl, startedAtMs));
    }

    public boolean isViewStillUsable(ImageRequest request) {
        return this.isViewStillUsable((View)request.getTargetView(), request.getTargetUrl(), request.getStartedAtMs());
    }

    private boolean isViewStillUsable(View target, String targetUrl, long startedAtMs) {
        return this.combineViewNameParams(targetUrl, startedAtMs).equals(this.views.get(target));
    }

    private String combineViewNameParams(String targetUrl, long startedAtMs) {
        return targetUrl + "_" + startedAtMs;
    }

    public FileCache getFileCache() {
        return this.fileCache;
    }

    public StubHolder getStubs() {
        if (this.stubHolder == null) {
            return this.defaultStubHolder;
        }
        return this.stubHolder;
    }

    public StubHolder getResourceBasedStubs() {
        if (this.stubHolder == null) {
            return this.defaultResourceStubHolder;
        }
        return this.stubHolder;
    }

    public void registerStubs(StubHolder stubHolder) {
        this.stubHolder = stubHolder;
    }

    public boolean isImageDownloaded(ImageRequest request) {
        return request.getOriginalRequestFile().exists() && this.context.getSharedPreferences(PREFS, 0).getBoolean(request.getTargetUrl(), false);
    }

    public Handler getHandler() {
        return this.handler;
    }
}

