/*
 * Decompiled with CFR 0.152.
 */
package com.guardanis.imageloader.filters;

import android.content.Context;
import android.graphics.Bitmap;
import com.guardanis.imageloader.filters.ImageFilter;
import java.util.HashMap;
import java.util.Map;

public class BitmapColorReplacementFilter
extends ImageFilter<Bitmap> {
    private Map<Integer, Integer> replacements;

    public BitmapColorReplacementFilter(Context context, int replace, int with) {
        super(context);
        this.replacements = new HashMap<Integer, Integer>();
        this.replacements.put(replace, with);
    }

    public BitmapColorReplacementFilter(Context context, Map<Integer, Integer> replacements) {
        super(context);
        this.replacements = replacements;
    }

    @Override
    public Bitmap filter(Bitmap unedited) {
        if (unedited != null) {
            if (!unedited.isMutable()) {
                unedited = this.mutate(unedited);
            }
            unedited.setPixels(this.getReplacementPixels(unedited), 0, unedited.getWidth(), 0, 0, unedited.getWidth(), unedited.getHeight());
        }
        return unedited;
    }

    private int[] getReplacementPixels(Bitmap copy) {
        int[] pixels = new int[copy.getHeight() * copy.getWidth()];
        copy.getPixels(pixels, 0, copy.getWidth(), 0, 0, copy.getWidth(), copy.getHeight());
        for (int i = 0; i < pixels.length; ++i) {
            for (Integer key : this.replacements.keySet()) {
                if (pixels[i] != key) continue;
                pixels[i] = this.replacements.get(key);
            }
        }
        return pixels;
    }

    @Override
    public String getAdjustmentInfo() {
        String values = "";
        for (Integer key : this.replacements.keySet()) {
            values = values + key + "-" + this.replacements.get(key);
        }
        return this.getClass().getSimpleName() + "_" + values;
    }
}

