/*
 * Decompiled with CFR 0.152.
 */
package com.guardanis.imageloader;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.ColorFilter;
import android.graphics.drawable.Drawable;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.view.View;
import android.view.animation.Interpolator;
import android.widget.ImageView;
import com.guardanis.imageloader.ImageLoader;
import com.guardanis.imageloader.ImageUtils;
import com.guardanis.imageloader.R;
import com.guardanis.imageloader.StubHolder;
import com.guardanis.imageloader.filters.BitmapBlurFilter;
import com.guardanis.imageloader.filters.BitmapCenterCropFilter;
import com.guardanis.imageloader.filters.BitmapCircularCropFilter;
import com.guardanis.imageloader.filters.BitmapColorFilter;
import com.guardanis.imageloader.filters.BitmapColorOverlayFilter;
import com.guardanis.imageloader.filters.BitmapColorOverrideFilter;
import com.guardanis.imageloader.filters.BitmapColorReplacementFilter;
import com.guardanis.imageloader.filters.BitmapRotationFilter;
import com.guardanis.imageloader.filters.ImageFilter;
import com.guardanis.imageloader.processors.ExternalImageProcessor;
import com.guardanis.imageloader.processors.ImageAssetProcessor;
import com.guardanis.imageloader.processors.ImageFileProcessor;
import com.guardanis.imageloader.processors.ImageProcessor;
import com.guardanis.imageloader.processors.ImageResourceProcessor;
import com.guardanis.imageloader.transitions.TransitionController;
import com.guardanis.imageloader.transitions.modules.FadingTransitionModule;
import com.guardanis.imageloader.transitions.modules.RotationTransitionModule;
import com.guardanis.imageloader.transitions.modules.ScalingTransitionModule;
import com.guardanis.imageloader.transitions.modules.TransitionModule;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ImageRequest<V extends View>
implements Runnable {
    protected static final int DEFAULT_BLUR_RADIUS = 15;
    protected static final int DEFAULT_CROSS_FADE_DURATION = 300;
    protected static final int DEFAULT_SCALE_DURATION = 300;
    protected static final int DEFAULT_ROTATION_DURATION = 300;
    protected Context context;
    protected String targetUrl;
    protected int targetResourceId = -1;
    protected ImageUtils.ImageType targetImageType = ImageUtils.ImageType.BITMAP;
    protected ImageProcessor imageProcessor;
    protected boolean loadingTargetLocally = false;
    protected V targetView;
    protected boolean setImageAsBackground = false;
    protected int requiredImageWidth = -1;
    protected long maxCacheDurationMs = -1L;
    protected List<ImageFilter<Bitmap>> bitmapImageFilters = new ArrayList<ImageFilter<Bitmap>>();
    protected boolean showStubOnExecute = true;
    protected boolean showStubOnError = false;
    protected boolean disableExecutionStubIfDownloaded = true;
    protected boolean useOldResourceStubs = false;
    protected StubHolder stubHolder;
    protected TransitionController transitionController = new TransitionController(this);
    protected boolean exitTransitionsEnabled = true;
    protected boolean transitionOnSuccessEnabled = true;
    protected Map<String, String> httpRequestParams = new HashMap<String, String>();
    protected ImageSuccessCallback successCallback;
    protected boolean triggerSuccessForValidViewsOnly = true;
    protected ImageErrorCallback errorCallback;
    protected boolean tagRequestPreventionEnabled = false;
    protected long startedAtMs;

    public ImageRequest(Context context) {
        this.context = context;
        this.showStubOnExecute = context.getResources().getBoolean(R.bool.ail__show_stub_on_execute);
        this.showStubOnError = context.getResources().getBoolean(R.bool.ail__show_stub_on_error);
        this.useOldResourceStubs = context.getResources().getBoolean(R.bool.ail__use_old_resource_stubs);
    }

    public ImageRequest(Context context, V targetView) {
        this(context);
        this.targetView = targetView;
    }

    public ImageRequest<V> setTargetUrl(String targetUrl) {
        this.targetUrl = targetUrl;
        this.targetImageType = ImageUtils.getImageType(this.context, targetUrl);
        this.loadingTargetLocally = false;
        this.imageProcessor = new ExternalImageProcessor();
        return this;
    }

    public ImageRequest<V> setTargetAsset(String targetAssetUrl) {
        this.targetUrl = targetAssetUrl;
        this.targetImageType = ImageUtils.getImageType(this.context, this.targetUrl);
        this.loadingTargetLocally = true;
        this.showStubOnExecute = this.context.getResources().getBoolean(R.bool.ail__local_execution_stubs);
        this.imageProcessor = new ImageAssetProcessor();
        return this;
    }

    public ImageRequest<V> setTargetFile(String file) {
        return this.setTargetFile(new File(file));
    }

    public ImageRequest<V> setTargetFile(File file) {
        this.targetUrl = file.getAbsolutePath();
        this.targetImageType = ImageUtils.getImageType(this.context, this.targetUrl);
        this.loadingTargetLocally = true;
        this.showStubOnExecute = this.context.getResources().getBoolean(R.bool.ail__local_execution_stubs);
        this.imageProcessor = new ImageFileProcessor();
        return this;
    }

    public ImageRequest<V> setTargetResource(int targetResourceId) {
        return this.setTargetResource(targetResourceId, ImageUtils.ImageType.BITMAP);
    }

    public ImageRequest<V> setTargetResource(int targetResourceId, ImageUtils.ImageType type) {
        this.targetResourceId = targetResourceId;
        this.targetImageType = type;
        this.loadingTargetLocally = true;
        this.showStubOnExecute = this.context.getResources().getBoolean(R.bool.ail__local_execution_stubs);
        this.imageProcessor = new ImageResourceProcessor();
        return this;
    }

    public ImageRequest<V> setTargetView(V targetView) {
        this.targetView = targetView;
        return this;
    }

    public ImageRequest<V> addHttpRequestParam(String key, String value) {
        this.httpRequestParams.put(key, value);
        return this;
    }

    public ImageRequest<V> setRequiredImageWidth(int requiredImageWidth) {
        this.requiredImageWidth = requiredImageWidth;
        return this;
    }

    public ImageRequest<V> setImageAsBackground() {
        this.setImageAsBackground = true;
        return this;
    }

    public ImageRequest<V> setImageAsBackground(boolean setImageAsBackground) {
        this.setImageAsBackground = setImageAsBackground;
        return this;
    }

    public ImageRequest<V> setShowStubOnExecute(boolean showStubOnExecute) {
        this.showStubOnExecute = showStubOnExecute;
        return this;
    }

    public ImageRequest<V> setShowStubOnError(boolean showStubOnError) {
        this.showStubOnError = showStubOnError;
        return this;
    }

    public ImageRequest<V> setDisableExecutionStubIfDownloaded(boolean disableExecutionStubIfDownloaded) {
        this.disableExecutionStubIfDownloaded = disableExecutionStubIfDownloaded;
        return this;
    }

    public ImageRequest<V> setUseOldResourceStubs(boolean useOldResourceStubs) {
        this.useOldResourceStubs = useOldResourceStubs;
        return this;
    }

    public ImageRequest<V> setMaxCacheDurationMs(long maxCacheDurationMs) {
        this.maxCacheDurationMs = maxCacheDurationMs;
        return this;
    }

    public ImageRequest<V> setSuccessCallback(ImageSuccessCallback successCallback) {
        this.successCallback = successCallback;
        return this;
    }

    public ImageRequest<V> setTriggerSuccessForValidViewsOnly(boolean triggerSuccessForValidViewsOnly) {
        this.triggerSuccessForValidViewsOnly = triggerSuccessForValidViewsOnly;
        return this;
    }

    public ImageRequest<V> setErrorCallback(ImageErrorCallback errorCallback) {
        this.errorCallback = errorCallback;
        return this;
    }

    public ImageRequest<V> addBlurFilter() {
        return this.addBlurFilter(15);
    }

    public ImageRequest<V> addBlurFilter(int blurRadius) {
        return this.addImageFilter(new BitmapBlurFilter(this.context, blurRadius));
    }

    public ImageRequest<V> addColorOverlayFilter(int colorOverlay) {
        return this.addImageFilter(new BitmapColorOverlayFilter(this.context, colorOverlay));
    }

    public ImageRequest<V> addRotationFilter(int rotationDegrees) {
        return this.addImageFilter(new BitmapRotationFilter(this.context, rotationDegrees));
    }

    public ImageRequest<V> addCircularCropFilter() {
        return this.addImageFilter(new BitmapCircularCropFilter(this.context));
    }

    public ImageRequest<V> addColorOverrideFilter(int replacementColor) {
        return this.addImageFilter(new BitmapColorOverrideFilter(this.context, replacementColor));
    }

    public ImageRequest<V> addColorReplacementFilter(int replace, int with) {
        return this.addImageFilter(new BitmapColorReplacementFilter(this.context, replace, with));
    }

    public ImageRequest<V> addColorReplacementFilter(Map<Integer, Integer> replacements) {
        return this.addImageFilter(new BitmapColorReplacementFilter(this.context, replacements));
    }

    public ImageRequest<V> addColorFilter(ColorFilter filter) {
        return this.addImageFilter(new BitmapColorFilter(this.context, filter));
    }

    public ImageRequest<V> addCenterCropFilter(int width, int height) {
        return this.addImageFilter(new BitmapCenterCropFilter(this.context, new int[]{width, height}));
    }

    public ImageRequest<V> addImageFilter(ImageFilter<Bitmap> imageFilter) {
        this.bitmapImageFilters.add(imageFilter);
        return this;
    }

    public ImageRequest<V> overrideStubs(StubHolder stubHolder) {
        this.stubHolder = stubHolder;
        return this;
    }

    public ImageRequest<V> setDefaultImageTransition() {
        this.transitionController.unregisterModules();
        return this;
    }

    public ImageRequest<V> setFadeTransition() {
        return this.setFadeTransition(300L);
    }

    public ImageRequest<V> setFadeTransition(long duration) {
        return this.addImageTransitionModule(new FadingTransitionModule(duration));
    }

    public ImageRequest<V> setScaleTransition(float from, float to) {
        return this.setScaleTransition(from, to, 300L);
    }

    public ImageRequest<V> setScaleTransition(float from, float to, long duration) {
        return this.addImageTransitionModule(new ScalingTransitionModule(from, to, duration));
    }

    public ImageRequest<V> setRotationTransition(int from, int to) {
        return this.setRotationTransition(from, to, 300L);
    }

    public ImageRequest<V> setRotationTransition(int from, int to, long duration) {
        return this.addImageTransitionModule(new RotationTransitionModule(from, to, duration));
    }

    public ImageRequest<V> addImageTransitionModule(TransitionModule module) {
        this.transitionController.registerModule(module);
        return this;
    }

    public ImageRequest<V> setExitTransitionsEnabled(boolean exitTransitionsEnabled) {
        this.exitTransitionsEnabled = exitTransitionsEnabled;
        return this;
    }

    public ImageRequest<V> setTransitionOnSuccessEnabled(boolean transitionOnSuccessEnabled) {
        this.transitionOnSuccessEnabled = transitionOnSuccessEnabled;
        return this;
    }

    public ImageRequest<V> registerImageTransitionInterpolator(Class c, int interpolatorId, Interpolator interpolator) {
        this.transitionController.registerModuleInterpolator(c, interpolatorId, interpolator);
        return this;
    }

    public ImageRequest<V> setTagRequestPreventionEnabled(boolean tagRequestPreventionEnabled) {
        this.tagRequestPreventionEnabled = tagRequestPreventionEnabled;
        return this;
    }

    @Override
    public void run() {
        if (this.targetView != null && ImageLoader.getInstance(this.context).isViewStillUsable(this)) {
            try {
                Drawable processed = this.imageProcessor.process(this, this.bitmapImageFilters);
                this.onRequestCompleted(processed);
            }
            catch (Throwable e) {
                ImageUtils.log(this.context, e);
                this.onRequestFailed();
            }
        }
    }

    protected int getRequiredImageWidth() {
        return this.requiredImageWidth < 1 ? this.targetView.getLayoutParams().width : this.requiredImageWidth;
    }

    protected void onRequestCompleted(final @Nullable Drawable targetDrawable) {
        if (targetDrawable == null) {
            this.onRequestFailed();
            return;
        }
        if (this.targetView == null) {
            return;
        }
        if (ImageLoader.getInstance(this.context).isViewStillUsable(this)) {
            if (this.transitionOnSuccessEnabled) {
                this.transitionController.transitionTo(targetDrawable);
            }
        } else if (this.triggerSuccessForValidViewsOnly) {
            return;
        }
        this.post(new Runnable(){

            @Override
            public void run() {
                if (ImageRequest.this.successCallback != null) {
                    ImageRequest.this.successCallback.onImageReady(ImageRequest.this, targetDrawable);
                }
            }
        });
    }

    protected void onRequestFailed() {
        if (this.targetView == null || !ImageLoader.getInstance(this.context).isViewStillUsable(this)) {
            return;
        }
        this.handleShowStubOnError();
        this.post(new Runnable(){

            @Override
            public void run() {
                if (ImageRequest.this.errorCallback != null) {
                    ImageRequest.this.errorCallback.onImageLoadingFailure(ImageRequest.this, new RuntimeException("Image could not be loaded"));
                }
            }
        });
    }

    protected void handleShowStubOnError() {
        Drawable targetDrawable = this.showStubOnError ? this.getStubs().getErrorDrawable(this.context) : ContextCompat.getDrawable((Context)this.context, (int)R.drawable.ail__default_fade_placeholder);
        this.transitionController.transitionTo(targetDrawable);
    }

    protected String getEditedRequestFileCacheName() {
        String adjustedName = this.getOriginalRequestFileCacheName();
        for (ImageFilter<Bitmap> filter : this.bitmapImageFilters) {
            adjustedName = adjustedName + "_" + filter.getAdjustmentInfo();
        }
        return adjustedName;
    }

    public File getEditedRequestFile() {
        return ImageLoader.getInstance(this.context).getFileCache().getFile(this.getEditedRequestFileCacheName());
    }

    protected String getOriginalRequestFileCacheName() {
        return 0 < this.targetResourceId ? String.valueOf(this.targetResourceId) : this.targetUrl;
    }

    public Context getContext() {
        return this.context;
    }

    public boolean isSetImageAsBackgroundForced() {
        return this.setImageAsBackground;
    }

    public boolean isRequestForBackgroundImage() {
        return this.setImageAsBackground || !(this.targetView instanceof ImageView);
    }

    public V getTargetView() {
        return this.targetView;
    }

    public Map<String, String> getHttpRequestParams() {
        return this.httpRequestParams;
    }

    public long getMaxCacheDurationMs() {
        return this.maxCacheDurationMs;
    }

    public File getOriginalRequestFile() {
        return ImageLoader.getInstance(this.context).getFileCache().getFile(this.getOriginalRequestFileCacheName());
    }

    protected StubHolder getStubs() {
        if (this.stubHolder == null) {
            return this.useOldResourceStubs ? ImageLoader.getInstance(this.context).getResourceBasedStubs() : ImageLoader.getInstance(this.context).getStubs();
        }
        return this.stubHolder;
    }

    public String getTargetUrl() {
        return this.targetUrl;
    }

    public int getTargetResourceId() {
        return this.targetResourceId;
    }

    public boolean isExitTransitionEnabled() {
        return this.exitTransitionsEnabled;
    }

    public long getStartedAtMs() {
        return this.startedAtMs;
    }

    public boolean isTargetLocal() {
        return this.loadingTargetLocally;
    }

    public int getTargetImageWidth() {
        return this.getRequiredImageWidth();
    }

    public ImageUtils.ImageType getTargetImageType() {
        return this.targetImageType;
    }

    protected void post(Runnable runnable) {
        if (this.targetView == null) {
            ImageLoader.getInstance(this.context).getHandler().post(runnable);
        } else {
            this.targetView.post(runnable);
        }
    }

    protected boolean isTargetDefined() {
        return (this.targetUrl != null && 0 < this.targetUrl.length() || 0 < this.targetResourceId) && this.imageProcessor != null;
    }

    private void handleShowStubOnExecute() {
        if (this.disableExecutionStubIfDownloaded && ImageLoader.getInstance(this.context).isImageDownloaded(this) && ImageLoader.getInstance(this.context).getFileCache().isCachedFileValid(this.targetUrl, this.maxCacheDurationMs)) {
            return;
        }
        Drawable targetDrawable = this.showStubOnExecute ? this.getStubs().getLoadingDrawable(this.context) : ContextCompat.getDrawable((Context)this.context, (int)R.drawable.ail__default_fade_placeholder);
        this.transitionController.transitionTo(targetDrawable);
    }

    public ImageRequest<V> execute() {
        if (!this.isTargetDefined()) {
            throw new RuntimeException("No target URL or resource defined!");
        }
        final String fullRequestFile = this.getEditedRequestFileCacheName();
        if (this.tagRequestPreventionEnabled && this.targetView != null && this.targetView.getTag() != null && this.targetView.getTag().equals(fullRequestFile)) {
            ImageUtils.log(this.context, "Request already claimed. Ignoring [" + fullRequestFile + "]");
            return this;
        }
        this.startedAtMs = System.currentTimeMillis();
        if (this.targetView == null) {
            ImageLoader.getInstance(this.context).submit(this);
        } else {
            ImageLoader.getInstance(this.context).getHandler().post(new Runnable(){

                @Override
                public void run() {
                    if (ImageRequest.this.tagRequestPreventionEnabled) {
                        ImageRequest.this.targetView.setTag((Object)fullRequestFile);
                    }
                    ImageLoader.getInstance(ImageRequest.this.context).claimViewTarget(ImageRequest.this);
                    ImageRequest.this.handleShowStubOnExecute();
                    ImageRequest.this.targetView.post(new Runnable(){

                        @Override
                        public void run() {
                            ImageLoader.getInstance(ImageRequest.this.context).submit(ImageRequest.this);
                        }
                    });
                }
            });
        }
        return this;
    }

    public ImageRequest<V> execute(long delay) {
        ImageLoader.getInstance(this.context).getHandler().postDelayed(new Runnable(){

            @Override
            public void run() {
                ImageRequest.this.execute();
            }
        }, delay);
        return this;
    }

    public static interface ImageErrorCallback {
        public void onImageLoadingFailure(ImageRequest var1, @Nullable Throwable var2);
    }

    public static interface ImageSuccessCallback {
        public void onImageReady(ImageRequest var1, Drawable var2);
    }
}

