/*
 * Decompiled with CFR 0.152.
 */
package com.guardanis.imageloader.transitions.drawables;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import com.guardanis.imageloader.stubs.AnimatedStubDrawable;
import com.guardanis.imageloader.stubs.StubDrawable;
import com.guardanis.imageloader.transitions.modules.TransitionModule;
import java.util.HashMap;
import java.util.Map;

public class TransitionDrawable
extends BitmapDrawable {
    protected Drawable oldDrawable;
    protected Drawable targetDrawable;
    protected Matrix baseCanvasMatrix = new Matrix();
    protected Matrix canvasMatrixOverride;
    protected Map<Class, TransitionModule> modules = new HashMap<Class, TransitionModule>();
    protected TransitionStage transitionStage = TransitionStage.AWAITING_START;
    protected long animationStart = System.currentTimeMillis();
    protected int overriddenMaxAlpha = 255;

    public TransitionDrawable(Context context, Drawable from, Drawable to, Bitmap canvas) {
        super(context.getResources(), canvas);
        this.oldDrawable = from;
        this.targetDrawable = to;
    }

    public TransitionDrawable registerModule(TransitionModule module) {
        if (module != null) {
            this.modules.put(module.getClass(), module);
        }
        return this;
    }

    public void start() {
        this.animationStart = System.currentTimeMillis();
        this.transitionStage = TransitionStage.TRANSITIONING;
        this.invalidateSelf();
    }

    public void overrideCanvasMatrix(Matrix canvasMatrixOverride) {
        this.canvasMatrixOverride = canvasMatrixOverride;
    }

    public void draw(Canvas canvas) {
        if (this.canvasMatrixOverride != null) {
            canvas.setMatrix(this.canvasMatrixOverride);
        }
        if (this.transitionStage == TransitionStage.TRANSITIONING) {
            boolean unfinishedExists = false;
            for (TransitionModule module : this.modules.values()) {
                if (System.currentTimeMillis() >= this.animationStart + module.getDuration()) continue;
                unfinishedExists = true;
            }
            if (unfinishedExists) {
                this.updateModulesAndDraw(canvas, this.animationStart);
                this.invalidateSelf();
            } else {
                this.transitionStage = TransitionStage.FINISHED;
                this.oldDrawable = null;
                this.handlePostTransitionDrawing(canvas);
            }
        } else if (this.transitionStage == TransitionStage.AWAITING_START) {
            this.updateOldAndDraw(canvas, System.currentTimeMillis());
        } else {
            this.handlePostTransitionDrawing(canvas);
        }
        canvas.getMatrix(this.baseCanvasMatrix);
    }

    protected void updateModulesAndDraw(Canvas canvas, long startTime) {
        this.updateOldAndDraw(canvas, startTime);
        canvas.save();
        for (TransitionModule module : this.modules.values()) {
            module.onPredrawTarget(this, canvas, this.targetDrawable, startTime);
        }
        this.drawTarget(canvas);
        canvas.restore();
        this.safelyRevertTargetDrawables();
    }

    protected void updateOldAndDraw(Canvas canvas, long startTime) {
        if (this.oldDrawable != null) {
            canvas.save();
            for (TransitionModule module : this.modules.values()) {
                module.onPredrawOld(this, canvas, this.oldDrawable, startTime);
            }
            this.drawOldDrawable(canvas);
            canvas.restore();
            this.safelyRevertOldDrawables();
        }
    }

    protected void drawOldDrawable(Canvas canvas) {
        canvas.save();
        int[] translation = this.calculateStubTranslation(this.oldDrawable);
        canvas.translate((float)translation[0], (float)translation[1]);
        this.oldDrawable.draw(canvas);
        canvas.restore();
    }

    protected void drawTarget(Canvas canvas) {
        if (this.targetDrawable instanceof StubDrawable) {
            this.targetDrawable.draw(canvas);
        } else {
            super.draw(canvas);
        }
    }

    protected void handlePostTransitionDrawing(Canvas canvas) {
        this.updateModulesAndDraw(canvas, this.animationStart);
        if (this.targetDrawable instanceof AnimatedStubDrawable) {
            this.invalidateSelf();
        }
    }

    protected int[] calculateStubTranslation(Drawable drawable2) {
        int halfXDistance = (Math.max(this.getBounds().right, drawable2.getBounds().right) - Math.min(this.getBounds().right, drawable2.getBounds().right)) / 2;
        if (this.getBounds().right < drawable2.getBounds().right) {
            halfXDistance *= -1;
        }
        int halfYDistance = (Math.max(this.getBounds().bottom, drawable2.getBounds().bottom) - Math.min(this.getBounds().bottom, drawable2.getBounds().bottom)) / 2;
        if (this.getBounds().bottom < drawable2.getBounds().bottom) {
            halfYDistance *= -1;
        }
        return new int[]{halfXDistance, halfYDistance};
    }

    protected void safelyRevertOldDrawables() {
        for (TransitionModule module : this.modules.values()) {
            try {
                module.revertPostDrawOld(this, this.oldDrawable);
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    protected void safelyRevertTargetDrawables() {
        for (TransitionModule module : this.modules.values()) {
            try {
                module.revertPostDrawTarget(this, this.targetDrawable);
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public void setAlpha(int alpha) {
        int correctedAlpha = Math.min(alpha, this.overriddenMaxAlpha);
        super.setAlpha(correctedAlpha);
    }

    public void overrideMaxAlphaOut(int overriddenMaxAlpha) {
        this.overriddenMaxAlpha = Math.min(overriddenMaxAlpha, this.overriddenMaxAlpha);
        if (this.oldDrawable != null && this.oldDrawable instanceof TransitionDrawable) {
            ((TransitionDrawable)this.oldDrawable).overrideMaxAlphaOut(this.overriddenMaxAlpha);
        }
    }

    public int getOverriddenMaxAlpha() {
        return this.overriddenMaxAlpha;
    }

    public Drawable getTargetDrawable() {
        return this.targetDrawable;
    }

    public Matrix getBaseCanvasMatrix() {
        return this.baseCanvasMatrix;
    }

    protected static enum TransitionStage {
        AWAITING_START,
        TRANSITIONING,
        FINISHED;

    }
}

