/*
 * Decompiled with CFR 0.152.
 */
package com.guardanis.imageloader.filters;

import android.content.Context;
import android.graphics.Bitmap;
import com.guardanis.imageloader.filters.ImageFilter;

public class BitmapColorOverrideFilter
extends ImageFilter<Bitmap> {
    private static final int BASE_MASK = 0xFFFFFF;
    private static final int ALPHA_POS = 24;
    private int replacementColor;

    public BitmapColorOverrideFilter(Context context, int replacementColor) {
        super(context);
        this.replacementColor = replacementColor;
    }

    @Override
    public Bitmap filter(Bitmap unedited) {
        if (unedited != null) {
            if (!unedited.isMutable()) {
                unedited = this.mutate(unedited);
            }
            unedited.setPixels(this.getReplacementPixels(unedited), 0, unedited.getWidth(), 0, 0, unedited.getWidth(), unedited.getHeight());
        }
        return unedited;
    }

    private int[] getReplacementPixels(Bitmap copy) {
        int[] pixels = new int[copy.getHeight() * copy.getWidth()];
        copy.getPixels(pixels, 0, copy.getWidth(), 0, 0, copy.getWidth(), copy.getHeight());
        for (int i = 0; i < pixels.length; ++i) {
            pixels[i] = pixels[i] >> 24 << 24 | this.replacementColor & 0xFFFFFF;
        }
        return pixels;
    }

    @Override
    public String getAdjustmentInfo() {
        return this.getClass().getSimpleName() + "_" + this.replacementColor;
    }
}

