/*
 * Decompiled with CFR 0.152.
 */
package com.guardanis.imageloader.filters;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import com.guardanis.imageloader.filters.ImageFilter;

public class BitmapRotationFilter
extends ImageFilter<Bitmap> {
    private int rotationDegrees;

    public BitmapRotationFilter(Context context, int rotationDegrees) {
        super(context);
        this.rotationDegrees = rotationDegrees;
    }

    @Override
    public Bitmap filter(Bitmap unedited) {
        if (this.rotationDegrees % 360 == 0) {
            return unedited;
        }
        Matrix mtx = new Matrix();
        mtx.setRotate((float)this.rotationDegrees, (float)(unedited.getWidth() / 2), (float)(unedited.getHeight() / 2));
        try {
            return Bitmap.createBitmap((Bitmap)unedited, (int)0, (int)0, (int)unedited.getWidth(), (int)unedited.getHeight(), (Matrix)mtx, (boolean)true);
        }
        catch (OutOfMemoryError e) {
            e.printStackTrace();
            System.gc();
            return unedited;
        }
    }
}

