/*
 * Decompiled with CFR 0.152.
 */
package com.guardanis.imageloader;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.ColorFilter;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.view.View;
import android.view.animation.Interpolator;
import android.widget.ImageView;
import com.guardanis.imageloader.ImageLoader;
import com.guardanis.imageloader.ImageUtils;
import com.guardanis.imageloader.R;
import com.guardanis.imageloader.StubHolder;
import com.guardanis.imageloader.filters.BitmapBlurFilter;
import com.guardanis.imageloader.filters.BitmapCircularCropFilter;
import com.guardanis.imageloader.filters.BitmapColorFilter;
import com.guardanis.imageloader.filters.BitmapColorOverlayFilter;
import com.guardanis.imageloader.filters.BitmapColorReplacementFilter;
import com.guardanis.imageloader.filters.BitmapRotationFilter;
import com.guardanis.imageloader.filters.ImageFilter;
import com.guardanis.imageloader.transitions.TransitionController;
import com.guardanis.imageloader.transitions.modules.FadingTransitionModule;
import com.guardanis.imageloader.transitions.modules.RotationTransitionModule;
import com.guardanis.imageloader.transitions.modules.ScalingTransitionModule;
import com.guardanis.imageloader.transitions.modules.TransitionModule;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ImageRequest<V extends View>
implements Runnable {
    protected static final int DEFAULT_BLUR_RADIUS = 15;
    protected static final int DEFAULT_CROSS_FADE_DURATION = 300;
    protected static final int DEFAULT_SCALE_DURATION = 300;
    protected static final int DEFAULT_ROTATION_DURATION = 300;
    protected Context context;
    protected String targetUrl;
    protected V targetView;
    protected boolean setImageAsBackground = false;
    protected int requiredImageWidth = -1;
    protected long maxCacheDurationMs = -1L;
    protected List<ImageFilter<Bitmap>> bitmapImageFilters = new ArrayList<ImageFilter<Bitmap>>();
    protected boolean showStubOnExecute = true;
    protected boolean showStubOnError = false;
    protected boolean disableExecutionStubIfDownloaded = true;
    protected boolean useOldResourceStubs = false;
    protected StubHolder stubHolder;
    protected TransitionController transitionController = new TransitionController(this);
    protected boolean exitTransitionsEnabled = true;
    protected Map<String, String> httpRequestParams = new HashMap<String, String>();
    protected ImageSuccessCallback successCallback;
    protected ImageErrorCallback errorCallback;

    public ImageRequest(Context context) {
        this(context, "");
    }

    public ImageRequest(Context context, String targetUrl) {
        this.context = context;
        this.targetUrl = targetUrl;
        this.showStubOnExecute = context.getResources().getBoolean(R.bool.ail__show_stub_on_execute);
        this.showStubOnError = context.getResources().getBoolean(R.bool.ail__show_stub_on_error);
        this.useOldResourceStubs = context.getResources().getBoolean(R.bool.ail__use_old_resource_stubs);
    }

    public ImageRequest<V> setTargetUrl(String targetUrl) {
        this.targetUrl = targetUrl;
        return this;
    }

    public ImageRequest<V> setTargetView(V targetView) {
        this.targetView = targetView;
        return this;
    }

    public ImageRequest<V> addHttpRequestParam(String key, String value) {
        this.httpRequestParams.put(key, value);
        return this;
    }

    public ImageRequest<V> setRequiredImageWidth(int requiredImageWidth) {
        this.requiredImageWidth = requiredImageWidth;
        return this;
    }

    public ImageRequest<V> setImageAsBackground() {
        this.setImageAsBackground = true;
        return this;
    }

    public ImageRequest<V> setImageAsBackground(boolean setImageAsBackground) {
        this.setImageAsBackground = setImageAsBackground;
        return this;
    }

    public ImageRequest<V> setShowStubOnExecute(boolean showStubOnExecute) {
        this.showStubOnExecute = showStubOnExecute;
        return this;
    }

    public ImageRequest<V> setShowStubOnError(boolean showStubOnError) {
        this.showStubOnError = showStubOnError;
        return this;
    }

    public ImageRequest<V> setDisableExecutionStubIfDownloaded(boolean disableExecutionStubIfDownloaded) {
        this.disableExecutionStubIfDownloaded = disableExecutionStubIfDownloaded;
        return this;
    }

    public ImageRequest<V> setUseOldResourceStubs(boolean useOldResourceStubs) {
        this.useOldResourceStubs = useOldResourceStubs;
        return this;
    }

    public ImageRequest<V> setMaxCacheDurationMs(long maxCacheDurationMs) {
        this.maxCacheDurationMs = maxCacheDurationMs;
        return this;
    }

    public ImageRequest<V> setSuccessCallback(ImageSuccessCallback successCallback) {
        this.successCallback = successCallback;
        return this;
    }

    public ImageRequest<V> setErrorCallback(ImageErrorCallback errorCallback) {
        this.errorCallback = errorCallback;
        return this;
    }

    public ImageRequest<V> addBlurFilter() {
        return this.addBlurFilter(15);
    }

    public ImageRequest<V> addBlurFilter(int blurRadius) {
        this.bitmapImageFilters.add(new BitmapBlurFilter(this.context, blurRadius));
        return this;
    }

    public ImageRequest<V> addColorOverlayFilter(int colorOverlay) {
        this.bitmapImageFilters.add(new BitmapColorOverlayFilter(this.context, colorOverlay));
        return this;
    }

    public ImageRequest<V> addRotationFilter(int rotationDegrees) {
        this.bitmapImageFilters.add(new BitmapRotationFilter(this.context, rotationDegrees));
        return this;
    }

    public ImageRequest<V> addCircularCropFilter() {
        this.bitmapImageFilters.add(new BitmapCircularCropFilter(this.context));
        return this;
    }

    public ImageRequest<V> addColorReplacementFilter(int replace, int with) {
        this.bitmapImageFilters.add(new BitmapColorReplacementFilter(this.context, replace, with));
        return this;
    }

    public ImageRequest<V> addColorReplacementFilter(Map<Integer, Integer> replacements) {
        this.bitmapImageFilters.add(new BitmapColorReplacementFilter(this.context, replacements));
        return this;
    }

    public ImageRequest<V> addColorFilter(ColorFilter filter) {
        this.bitmapImageFilters.add(new BitmapColorFilter(this.context, filter));
        return this;
    }

    public ImageRequest<V> addImageFilter(ImageFilter<Bitmap> imageFilter) {
        this.bitmapImageFilters.add(imageFilter);
        return this;
    }

    public ImageRequest<V> overrideStubs(StubHolder stubHolder) {
        this.stubHolder = stubHolder;
        return this;
    }

    public ImageRequest<V> setDefaultImageTransition() {
        this.transitionController.unregisterModules();
        return this;
    }

    public ImageRequest<V> setFadeTransition() {
        return this.setFadeTransition(300L);
    }

    public ImageRequest<V> setFadeTransition(long duration) {
        return this.addImageTransitionModule(new FadingTransitionModule(duration));
    }

    public ImageRequest<V> setScaleTransition(float from, float to) {
        return this.setScaleTransition(from, to, 300L);
    }

    public ImageRequest<V> setScaleTransition(float from, float to, long duration) {
        return this.addImageTransitionModule(new ScalingTransitionModule(from, to, duration));
    }

    public ImageRequest<V> setRotationTransition(int from, int to) {
        return this.setRotationTransition(from, to, 300L);
    }

    public ImageRequest<V> setRotationTransition(int from, int to, long duration) {
        return this.addImageTransitionModule(new RotationTransitionModule(from, to, duration));
    }

    public ImageRequest<V> addImageTransitionModule(TransitionModule module) {
        this.transitionController.registerModule(module);
        return this;
    }

    public ImageRequest<V> setExitTransitionsEnabled(boolean exitTransitionsEnabled) {
        this.exitTransitionsEnabled = exitTransitionsEnabled;
        return this;
    }

    public ImageRequest<V> registerImageTransitionInterpolator(Class c, int interpolatorId, Interpolator interpolator) {
        this.transitionController.registerModuleInterpolator(c, interpolatorId, interpolator);
        return this;
    }

    @Override
    public void run() {
        if (this.targetView != null && ImageLoader.getInstance(this.context).isViewStillUsable((View)this.targetView, this.targetUrl)) {
            this.performFullImageRequest();
        }
    }

    protected void performFullImageRequest() {
        int requiredImageWidth = this.getRequiredImageWidth();
        File imageFile = this.getEditedRequestFile();
        if (!imageFile.exists()) {
            File originalImageFile = this.getOriginalRequestFile();
            if (!originalImageFile.exists()) {
                this.onRequestFailed();
            } else {
                this.processImage(imageFile, ImageUtils.decodeFile(originalImageFile, requiredImageWidth));
            }
        } else {
            this.onRequestCompleted(ImageUtils.decodeFile(imageFile, requiredImageWidth));
        }
    }

    protected int getRequiredImageWidth() {
        return this.requiredImageWidth < 1 ? this.targetView.getLayoutParams().width : this.requiredImageWidth;
    }

    protected void processImage(File imageFile, Bitmap bitmap) {
        if (0 < this.bitmapImageFilters.size()) {
            bitmap = this.applyBitmapFilters(bitmap);
            this.saveBitmap(imageFile, bitmap);
        }
        this.onRequestCompleted(bitmap);
    }

    protected Bitmap applyBitmapFilters(Bitmap bitmap) {
        for (ImageFilter<Bitmap> filter : this.bitmapImageFilters) {
            bitmap = filter.filter(bitmap);
        }
        return bitmap;
    }

    protected void saveBitmap(File imageFile, Bitmap bitmap) {
        ImageUtils.saveBitmapAsync(this.context, imageFile, bitmap);
    }

    protected void onRequestCompleted(final @Nullable Bitmap bitmap) {
        if (bitmap == null) {
            this.onRequestFailed();
            return;
        }
        if (this.targetView == null || !ImageLoader.getInstance(this.context).isViewStillUsable((View)this.targetView, this.targetUrl)) {
            return;
        }
        BitmapDrawable targetDrawable = new BitmapDrawable(this.targetView.getContext().getResources(), bitmap);
        this.transitionController.transitionTo((Drawable)targetDrawable);
        this.targetView.post(new Runnable(){

            @Override
            public void run() {
                if (ImageRequest.this.successCallback != null) {
                    ImageRequest.this.successCallback.onImageReady(ImageRequest.this, bitmap);
                }
            }
        });
    }

    protected void onRequestFailed() {
        if (this.targetView == null || !ImageLoader.getInstance(this.context).isViewStillUsable((View)this.targetView, this.targetUrl)) {
            return;
        }
        this.handleShowStubOnError();
        this.targetView.post(new Runnable(){

            @Override
            public void run() {
                if (ImageRequest.this.errorCallback != null) {
                    ImageRequest.this.errorCallback.onImageLoadingFailure(ImageRequest.this, new RuntimeException("Image could not be loaded"));
                }
            }
        });
    }

    protected void handleShowStubOnError() {
        Drawable targetDrawable = this.showStubOnError ? this.getStubs().getErrorDrawable(this.context) : ContextCompat.getDrawable((Context)this.context, (int)R.drawable.ail__default_fade_placeholder);
        this.transitionController.transitionTo(targetDrawable);
    }

    protected String getFullRequestFileCacheName() {
        String adjustedName = this.targetUrl;
        for (ImageFilter<Bitmap> filter : this.bitmapImageFilters) {
            adjustedName = adjustedName + "_" + filter.getAdjustmentInfo();
        }
        return adjustedName;
    }

    protected File getEditedRequestFile() {
        return ImageLoader.getInstance(this.context).getFileCache().getFile(this.getFullRequestFileCacheName());
    }

    protected String getOriginalRequestFileCacheName() {
        return this.targetUrl;
    }

    public Context getContext() {
        return this.context;
    }

    public boolean isSetImageAsBackgroundForced() {
        return this.setImageAsBackground;
    }

    public boolean isRequestForBackgroundImage() {
        return this.setImageAsBackground || !(this.targetView instanceof ImageView);
    }

    public V getTargetView() {
        return this.targetView;
    }

    public Map<String, String> getHttpRequestParams() {
        return this.httpRequestParams;
    }

    public long getMaxCacheDurationMs() {
        return this.maxCacheDurationMs;
    }

    public File getOriginalRequestFile() {
        return ImageLoader.getInstance(this.context).getFileCache().getFile(this.getOriginalRequestFileCacheName());
    }

    protected StubHolder getStubs() {
        if (this.stubHolder == null) {
            return this.useOldResourceStubs ? ImageLoader.getInstance(this.context).getResourceBasedStubs() : ImageLoader.getInstance(this.context).getStubs();
        }
        return this.stubHolder;
    }

    public String getTargetUrl() {
        return this.targetUrl;
    }

    public boolean isExitTransitionEnabled() {
        return this.exitTransitionsEnabled;
    }

    private void handleShowStubOnExecute() {
        if (this.disableExecutionStubIfDownloaded && ImageLoader.getInstance(this.context).isImageDownloaded(this) && ImageLoader.getInstance(this.context).getFileCache().isCachedFileValid(this.targetUrl, this.maxCacheDurationMs)) {
            return;
        }
        Drawable targetDrawable = this.showStubOnExecute ? this.getStubs().getLoadingDrawable(this.context) : ContextCompat.getDrawable((Context)this.context, (int)R.drawable.ail__default_fade_placeholder);
        this.transitionController.transitionTo(targetDrawable);
    }

    public ImageRequest<V> execute() {
        if (this.targetView == null) {
            ImageLoader.getInstance(this.context).submit(this);
        } else {
            this.targetView.post(new Runnable(){

                @Override
                public void run() {
                    ImageLoader.getInstance(ImageRequest.this.context).addViewAndTargetUrl((View)ImageRequest.this.targetView, ImageRequest.this.targetUrl);
                    ImageRequest.this.handleShowStubOnExecute();
                    ImageLoader.getInstance(ImageRequest.this.context).submit(ImageRequest.this);
                }
            });
        }
        return this;
    }

    public ImageRequest<V> execute(long delay) {
        Runnable execution = new Runnable(){

            @Override
            public void run() {
                ImageRequest.this.execute();
            }
        };
        if (this.targetView == null) {
            new Handler().postDelayed(execution, delay);
        } else {
            this.targetView.postDelayed(execution, delay);
        }
        return this;
    }

    public static interface ImageErrorCallback {
        public void onImageLoadingFailure(ImageRequest var1, @Nullable Throwable var2);
    }

    public static interface ImageSuccessCallback {
        public void onImageReady(ImageRequest var1, Bitmap var2);
    }
}

