/*
 * Decompiled with CFR 0.152.
 */
package com.guardanis.imageloader;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.view.View;
import com.guardanis.imageloader.ImageLoader;
import com.guardanis.imageloader.ImageRequest;
import com.guardanis.imageloader.ImageUtils;
import com.guardanis.imageloader.filters.ImageFilter;
import java.io.File;
import pl.droidsonroids.gif.GifDrawable;

public class GifRequest<V extends View>
extends ImageRequest<V> {
    protected FileLoader fileLoader;
    protected boolean requestIsLocal;

    public GifRequest(Context context) {
        super(context);
    }

    @Override
    public GifRequest<V> setTargetUrl(String targetUrl) {
        throw new UnsupportedOperationException("Gif targets must be exclusively declared.");
    }

    public GifRequest<V> setTargetExternalUrl(String targetUrl) {
        super.setTargetUrl(targetUrl);
        this.fileLoader = new FileLoader(){

            @Override
            public GifDrawable getGifDrawable() throws Exception {
                return new GifDrawable(GifRequest.this.getOriginalRequestFile());
            }
        };
        this.requestIsLocal = false;
        return this;
    }

    public GifRequest<V> setTargetAssetUrl(final String targetUrl) {
        super.setTargetUrl(targetUrl);
        this.fileLoader = new FileLoader(){

            @Override
            public GifDrawable getGifDrawable() throws Exception {
                return new GifDrawable(GifRequest.this.context.getAssets().openFd(targetUrl));
            }
        };
        this.requestIsLocal = true;
        return this;
    }

    public GifRequest<V> setTargetFileUrl(final String targetUrl) {
        super.setTargetUrl(targetUrl);
        this.fileLoader = new FileLoader(){

            @Override
            public GifDrawable getGifDrawable() throws Exception {
                return new GifDrawable(new File(targetUrl));
            }
        };
        this.requestIsLocal = true;
        return this;
    }

    @Override
    public ImageRequest<V> addImageFilter(ImageFilter<Bitmap> imageFilter) {
        throw new UnsupportedOperationException("ImageFilters of type Bitmap are unsupported for Gifs");
    }

    @Override
    public ImageRequest<V> setSuccessCallback(ImageRequest.ImageSuccessCallback successCallback) {
        throw new UnsupportedOperationException("Gif targets must be exclusively declared.");
    }

    @Override
    protected void performFullImageRequest() {
        try {
            this.onRequestCompleted(this.fileLoader.getGifDrawable());
        }
        catch (Exception e) {
            ImageUtils.log(this.context, e);
            this.onRequestFailed();
        }
    }

    protected void onRequestCompleted(GifDrawable gif) {
        if (gif == null) {
            this.onRequestFailed();
        } else if (this.targetView == null || !ImageLoader.getInstance(this.context).isViewStillUsable(this)) {
            return;
        }
        if (this.transitionOnSuccessEnabled) {
            this.transitionController.transitionTo((Drawable)gif);
        }
    }

    @Override
    public boolean isTargetLocal() {
        return this.requestIsLocal;
    }

    public static interface FileLoader {
        public GifDrawable getGifDrawable() throws Exception;
    }
}

