/*
 * Decompiled with CFR 0.152.
 */
package com.guardanis.imageloader.transitions.modules;

import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.Nullable;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import com.guardanis.imageloader.stubs.StubDrawable;
import com.guardanis.imageloader.transitions.drawables.TransitionDrawable;
import com.guardanis.imageloader.transitions.modules.TransitionModule;

public class FadingTransitionModule
extends TransitionModule {
    protected final int MAX_ALPHA = 255;
    protected final int TRANSITION_OUT_SPEED_MULTIPLIER = 2;
    protected int oldSDrawableStartingAlpha = 255;

    public FadingTransitionModule(long duration) {
        super(duration);
        this.registerInterpolator(1, (Interpolator)new AccelerateInterpolator());
        this.registerInterpolator(0, (Interpolator)new DecelerateInterpolator());
    }

    @Override
    public void onStart(@Nullable Drawable old, Drawable target) {
        if (Build.VERSION.SDK_INT >= 19) {
            this.oldSDrawableStartingAlpha = old.getAlpha();
        }
    }

    @Override
    public void onPredrawOld(TransitionDrawable transitionDrawable, Canvas canvas, @Nullable Drawable old, long startTime) {
        if (old != null) {
            int alpha = (int)Math.max(255.0f - (float)this.oldSDrawableStartingAlpha * this.interpolate(1, startTime) * 2.0f, 0.0f);
            int correctedAlpha = Math.min(alpha, transitionDrawable.getOverriddenMaxAlpha());
            if (old instanceof TransitionDrawable) {
                ((TransitionDrawable)old).overrideMaxAlphaOut(correctedAlpha);
            }
            old.setAlpha(correctedAlpha);
        }
    }

    @Override
    public void revertPostDrawOld(TransitionDrawable transitionDrawable, @Nullable Drawable old) {
        if (old != null) {
            old.setAlpha(255);
        }
    }

    @Override
    public void onPredrawTarget(TransitionDrawable transitionDrawable, Canvas canvas, Drawable target, long startTime) {
        if (target instanceof StubDrawable) {
            target.setAlpha((int)(255.0f * this.interpolate(0, startTime)));
        } else {
            transitionDrawable.setAlpha((int)(255.0f * this.interpolate(0, startTime)));
        }
    }

    @Override
    public void revertPostDrawTarget(TransitionDrawable transitionDrawable, Drawable target) {
        if (target instanceof StubDrawable) {
            target.setAlpha(255);
        } else {
            transitionDrawable.setAlpha(255);
        }
    }
}

