/*
 * Decompiled with CFR 0.152.
 */
package com.guardanis.imageloader.transitions;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.view.View;
import android.view.animation.Interpolator;
import android.widget.ImageView;
import com.guardanis.imageloader.ImageRequest;
import com.guardanis.imageloader.R;
import com.guardanis.imageloader.stubs.StubDrawable;
import com.guardanis.imageloader.transitions.drawables.TransitionDrawable;
import com.guardanis.imageloader.transitions.modules.TransitionModule;
import java.util.HashMap;
import java.util.Map;

public class TransitionController {
    protected ImageRequest request;
    protected Map<Class, TransitionModule> modules = new HashMap<Class, TransitionModule>();

    public TransitionController(ImageRequest request) {
        this.request = request;
    }

    public void registerModule(TransitionModule module) {
        if (module != null) {
            this.modules.put(module.getClass(), module);
        }
    }

    public void registerModuleInterpolator(Class c, int interpolatorId, Interpolator interpolator) {
        if (this.modules != null) {
            this.modules.get(c).registerInterpolator(interpolatorId, interpolator);
        }
    }

    public void unregisterModules() {
        this.modules = new HashMap<Class, TransitionModule>();
    }

    public void transitionTo(Drawable to) {
        if (this.modules.size() < 1) {
            this.setTargetViewDrawable(to);
        } else {
            Bitmap targetBitmap = this.getTargetBitmap(to, (View)this.request.getTargetView());
            TransitionDrawable drawable2 = new TransitionDrawable(this.request.getContext(), this.getCurrentTargetDrawable(targetBitmap), to, targetBitmap);
            for (TransitionModule module : this.modules.values()) {
                drawable2.registerModule(module);
            }
            this.setTransitionDrawable(drawable2);
        }
    }

    protected Drawable getCurrentTargetDrawable(Bitmap targetBitmap) {
        Drawable current;
        Drawable drawable2 = current = this.request.isRequestForBackgroundImage() ? this.request.getTargetView().getBackground() : ((ImageView)this.request.getTargetView()).getDrawable();
        if (current == null) {
            return ContextCompat.getDrawable((Context)this.request.getContext(), (int)R.drawable.ail__default_fade_placeholder);
        }
        if (current instanceof TransitionDrawable && ((TransitionDrawable)current).getTargetDrawable() instanceof StubDrawable) {
            return ((TransitionDrawable)current).getTargetDrawable();
        }
        return current;
    }

    protected Bitmap getTargetBitmap(Drawable drawable2, @Nullable View targetView) {
        if (drawable2 instanceof BitmapDrawable) {
            return ((BitmapDrawable)drawable2).getBitmap();
        }
        Bitmap bitmap = null;
        if (drawable2.getIntrinsicWidth() < 1 || drawable2.getIntrinsicHeight() < 1) {
            bitmap = targetView != null && targetView.getLayoutParams() != null && targetView.getLayoutParams().width >= 1 && targetView.getLayoutParams().height >= 1 ? Bitmap.createBitmap((int)targetView.getLayoutParams().width, (int)targetView.getLayoutParams().height, (Bitmap.Config)Bitmap.Config.ARGB_8888) : (drawable2.getBounds().right - drawable2.getBounds().left < 1 ? Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.ARGB_8888) : Bitmap.createBitmap((int)(drawable2.getBounds().right - drawable2.getBounds().left), (int)(drawable2.getBounds().bottom - drawable2.getBounds().top), (Bitmap.Config)Bitmap.Config.ARGB_8888));
        } else {
            Bitmap.createBitmap((int)drawable2.getIntrinsicWidth(), (int)drawable2.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        Canvas canvas = new Canvas(bitmap);
        drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable2.draw(canvas);
        return bitmap;
    }

    protected void setTransitionDrawable(final TransitionDrawable drawable2) {
        this.request.getTargetView().post(new Runnable(){

            @Override
            public void run() {
                if (TransitionController.this.request.isRequestForBackgroundImage()) {
                    TransitionController.this.setBackgroundDrawable((Drawable)drawable2);
                } else {
                    ((ImageView)TransitionController.this.request.getTargetView()).setImageDrawable((Drawable)drawable2);
                }
                drawable2.start();
            }
        });
    }

    protected void setTargetViewDrawable(final Drawable drawable2) {
        this.request.getTargetView().post(new Runnable(){

            @Override
            public void run() {
                if (TransitionController.this.request.isRequestForBackgroundImage()) {
                    TransitionController.this.setBackgroundDrawable(drawable2);
                } else {
                    ((ImageView)TransitionController.this.request.getTargetView()).setImageDrawable(drawable2);
                }
            }
        });
    }

    @SuppressLint(value={"NewApi"})
    protected void setBackgroundDrawable(Drawable drawable2) {
        if (Build.VERSION.SDK_INT < 16) {
            this.request.getTargetView().setBackgroundDrawable(drawable2);
        } else {
            this.request.getTargetView().setBackground(drawable2);
        }
    }
}

