/*
 * Decompiled with CFR 0.152.
 */
package com.guardanis.imageloader.transitions.modules;

import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.support.annotation.Nullable;
import com.guardanis.imageloader.transitions.drawables.TransitionDrawable;

public abstract class TransitionModule {
    protected long duration;

    public TransitionModule(long duration) {
        this.duration = duration;
    }

    public abstract void onStart(@Nullable Drawable var1, Drawable var2);

    public abstract void onPredrawOld(Canvas var1, @Nullable Drawable var2, long var3);

    public abstract void revertPostDrawOld(TransitionDrawable var1, @Nullable Drawable var2);

    public abstract void onPredrawTarget(TransitionDrawable var1, Canvas var2, Drawable var3, long var4);

    public abstract void revertPostDrawTarget(TransitionDrawable var1, Drawable var2);

    protected float calculatePercentCompleted(long startTimeMs) {
        return Math.min(1.0f, (float)(System.currentTimeMillis() - startTimeMs) / (float)this.duration);
    }

    public long getDuration() {
        return this.duration;
    }
}

