/*
 * Decompiled with CFR 0.152.
 */
package com.guardanis.imageloader;

import android.content.Context;
import android.graphics.Bitmap;
import android.view.View;
import com.guardanis.imageloader.ImageRequest;
import com.guardanis.imageloader.ImageUtils;
import java.io.File;

public abstract class LocalImageRequest<V extends View>
extends ImageRequest<V> {
    public LocalImageRequest(Context context) {
        this(context, "");
    }

    public LocalImageRequest(Context context, String targetUrl) {
        super(context, targetUrl);
        this.setShowStubOnExecute(false);
    }

    @Override
    protected void performFullImageRequest() {
        int requiredImageWidth = this.getRequiredImageWidth();
        File imageFile = this.getEditedRequestFile();
        if (imageFile.exists()) {
            this.onRequestCompleted(ImageUtils.decodeFile(imageFile, requiredImageWidth));
        } else {
            this.processImage(this.getEditedRequestFile(), this.decodeImageFile(requiredImageWidth));
        }
    }

    protected abstract Bitmap decodeImageFile(int var1);
}

