/*
 * Decompiled with CFR 0.152.
 */
package com.guardanis.imageloader.views;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.TypedArray;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewTreeObserver;
import android.widget.ImageView;
import com.caverock.androidsvg.SVG;
import com.guardanis.imageloader.ImageFileRequest;
import com.guardanis.imageloader.ImageRequest;
import com.guardanis.imageloader.ImageUtils;
import com.guardanis.imageloader.R;

public class SVGImageView
extends ImageView {
    public SVGImageView(Context context) {
        super(context);
        SVGImageView.disableHardwareAcceleration((View)this);
    }

    public SVGImageView(Context context, AttributeSet attrs) {
        super(context, attrs, 0);
        SVGImageView.disableHardwareAcceleration((View)this);
        this.init(attrs, 0);
    }

    public SVGImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        SVGImageView.disableHardwareAcceleration((View)this);
        this.init(attrs, defStyle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(AttributeSet attrs, int defStyle) {
        TypedArray a = this.getContext().getTheme().obtainStyledAttributes(attrs, R.styleable.SVGImageView, defStyle, 0);
        try {
            int resourceId = a.getResourceId(R.styleable.SVGImageView_svg, -1);
            if (resourceId != -1) {
                this.setImageResource(resourceId);
                return;
            }
            String url = a.getString(R.styleable.SVGImageView_svg);
            if (url != null) {
                this.setImageAsset(url);
            }
        }
        finally {
            a.recycle();
        }
    }

    public void setImageAsset(String filename) {
        try {
            if (filename.length() < 1) {
                this.setImageDrawable(null);
            } else {
                this.setImageSvg(SVG.getFromAsset((AssetManager)this.getContext().getAssets(), (String)filename));
            }
        }
        catch (Throwable e) {
            ImageUtils.log(this.getContext(), "Unable to find asset file: " + filename);
            this.setImageDrawable(null);
        }
    }

    public void setImageUrl(String url) {
        new ImageRequest<SVGImageView>(this.getContext(), url).setTargetView(this).setFadeTransition().execute();
    }

    public void setImageFile(String imageFile) {
        new ImageFileRequest<SVGImageView>(this.getContext(), imageFile).setTargetView(this).setFadeTransition().execute();
    }

    private void setImageSvg(final SVG svg) throws Throwable {
        this.getBestWidth(new LayoutEventListener(){

            @Override
            public void onLaidOut(int width) {
                SVGImageView.this.setImageBitmap(ImageUtils.decodeBitmap(svg, width));
            }
        });
    }

    private void getBestWidth(final LayoutEventListener eventListener) {
        if (this.getLayoutParams() == null) {
            this.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                public void onGlobalLayout() {
                    eventListener.onLaidOut(SVGImageView.this.getLayoutParams().width);
                    SVGImageView.removeOnGlobalLayoutListener((View)SVGImageView.this, this);
                }
            });
            this.requestLayout();
        } else {
            eventListener.onLaidOut(this.getLayoutParams().width);
        }
    }

    @SuppressLint(value={"NewApi"})
    public static void removeOnGlobalLayoutListener(View v, ViewTreeObserver.OnGlobalLayoutListener listener) {
        if (Build.VERSION.SDK_INT < 16) {
            v.getViewTreeObserver().removeGlobalOnLayoutListener(listener);
        } else {
            v.getViewTreeObserver().removeOnGlobalLayoutListener(listener);
        }
    }

    @SuppressLint(value={"NewApi"})
    public static void disableHardwareAcceleration(View v) {
        if (Build.VERSION.SDK_INT >= 11) {
            v.setLayerType(1, null);
        }
    }

    private static interface LayoutEventListener {
        public void onLaidOut(int var1);
    }
}

