/*
 * Decompiled with CFR 0.152.
 */
package com.guardanis.imageloader.stubs;

import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import com.guardanis.imageloader.R;
import com.guardanis.imageloader.stubs.AnimatedStubDrawable;

public class DefaultLoadingDrawable
extends AnimatedStubDrawable {
    private static final int MIN_ARC = 5;
    private static final int MAX_ARC = 360;
    private static final float ARC_SPEED = 7.25f;
    private static final float ROTATION_SPEED = 2.85f;
    private LoadingDrawableState state;
    private Paint loadingPaint = new Paint();
    private float rotationDegrees = 0.0f;
    private float arcAngle = 270.0f;
    private RectF drawableBounds = new RectF();
    private boolean arcModeLower = true;
    private int lastBoundedWidth = -1;

    public DefaultLoadingDrawable(Resources resources) {
        this(resources, resources.getColor(R.color.ail__default_stub_loading_tint));
    }

    public DefaultLoadingDrawable(Resources resources, int color2) {
        this.state = new LoadingDrawableState(resources);
        this.setBounds(0, 0, (int)resources.getDimension(R.dimen.ail__default_stub_loading_size), (int)resources.getDimension(R.dimen.ail__default_stub_loading_size));
        this.setupPaints(resources, color2);
    }

    protected void setupPaints(Resources resources, int color2) {
        this.loadingPaint.setAntiAlias(true);
        this.loadingPaint.setColor(color2);
        this.loadingPaint.setStyle(Paint.Style.STROKE);
        this.loadingPaint.setStrokeWidth(resources.getDimension(R.dimen.ail__default_stub_loading_stroke_width));
    }

    public void draw(Canvas canvas) {
        if (this.lastBoundedWidth != canvas.getWidth()) {
            this.setupRect(canvas);
        }
        canvas.save();
        canvas.rotate(this.rotationDegrees, (float)(canvas.getWidth() / 2), (float)(canvas.getHeight() / 2));
        canvas.drawArc(this.drawableBounds, 0.0f, this.arcAngle, false, this.loadingPaint);
        canvas.restore();
        this.updatePositions();
        this.invalidateSelf();
    }

    protected void setupRect(Canvas canvas) {
        int desiredSize = Math.min(canvas.getClipBounds().width() / 8, canvas.getClipBounds().height() / 5) / 2;
        int[] center = new int[]{canvas.getClipBounds().width() / 2, canvas.getClipBounds().height() / 2};
        this.drawableBounds.left = center[0] - desiredSize;
        this.drawableBounds.right = center[0] + desiredSize;
        this.drawableBounds.top = center[1] - desiredSize;
        this.drawableBounds.bottom = center[1] + desiredSize;
        this.lastBoundedWidth = canvas.getWidth();
    }

    protected void updatePositions() {
        this.rotationDegrees = (this.rotationDegrees + 2.85f) % 360.0f;
        if (this.arcModeLower) {
            this.arcAngle -= 7.25f;
            if (this.arcAngle <= 5.0f) {
                this.arcModeLower = false;
            }
        } else {
            this.arcAngle += 7.25f;
            if (360.0f <= this.arcAngle) {
                this.arcModeLower = true;
            }
        }
    }

    public int getOpacity() {
        return 1;
    }

    public void setAlpha(int alpha) {
        this.loadingPaint.setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter filter) {
        this.loadingPaint.setColorFilter(filter);
    }

    public Drawable.ConstantState getConstantState() {
        this.state.changingConfigurations = super.getChangingConfigurations();
        return this.state;
    }

    static final class LoadingDrawableState
    extends Drawable.ConstantState {
        private Resources resources;
        private int changingConfigurations;

        public LoadingDrawableState(Resources resources) {
            this.resources = resources;
        }

        public Drawable newDrawable() {
            return new DefaultLoadingDrawable(this.resources);
        }

        public Drawable newDrawable(Resources resources) {
            return new DefaultLoadingDrawable(resources);
        }

        public int getChangingConfigurations() {
            return this.changingConfigurations;
        }
    }
}

