/*
 * Decompiled with CFR 0.152.
 */
package com.guardanis.imageloader.filters;

import android.content.Context;
import android.graphics.Bitmap;
import android.support.v8.renderscript.Allocation;
import android.support.v8.renderscript.Element;
import android.support.v8.renderscript.RenderScript;
import android.support.v8.renderscript.ScriptIntrinsicBlur;
import android.support.v8.renderscript.Type;
import com.guardanis.imageloader.filters.ImageFilter;

public class BitmapBlurFilter
extends ImageFilter<Bitmap> {
    private float blurRadius;
    private static RenderScript renderScript;

    public BitmapBlurFilter(Context context, int blurRadius) {
        super(context);
        this.blurRadius = blurRadius;
    }

    @Override
    public Bitmap filter(Bitmap unedited) {
        try {
            if (renderScript == null) {
                renderScript = RenderScript.create((Context)this.context);
            }
            if (!unedited.isMutable()) {
                unedited = this.mutate(unedited);
            }
            Allocation input = Allocation.createFromBitmap((RenderScript)renderScript, (Bitmap)unedited, (Allocation.MipmapControl)Allocation.MipmapControl.MIPMAP_NONE, (int)1);
            Allocation output = Allocation.createTyped((RenderScript)renderScript, (Type)input.getType());
            ScriptIntrinsicBlur script = ScriptIntrinsicBlur.create((RenderScript)renderScript, (Element)Element.U8_4((RenderScript)renderScript));
            script.setRadius(this.blurRadius);
            script.setInput(input);
            script.forEach(output);
            output.copyTo(unedited);
        }
        catch (OutOfMemoryError e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return unedited;
    }

    @Override
    public String getAdjustmentInfo() {
        return this.getClass().getSimpleName() + "_" + this.blurRadius;
    }
}

