/*
 * Decompiled with CFR 0.152.
 */
package com.guardanis.imageloader;

import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Environment;
import android.util.Log;
import android.widget.Toast;
import com.caverock.androidsvg.SVG;
import com.guardanis.imageloader.FileCache;
import com.guardanis.imageloader.R;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;

public class ImageUtils {
    private static final int MAX_REDUCTION_FACTOR = 16;
    private static final String TAG = "AIL";

    protected ImageUtils() {
    }

    public static void saveStream(File file, InputStream is) throws Exception {
        FileOutputStream os = new FileOutputStream(file);
        ImageUtils.copyStream(is, os);
        ((OutputStream)os).close();
    }

    @Deprecated
    public static void saveBitmap(Context context, String filePath, Bitmap bitmap) {
        ImageUtils.saveBitmapAsync(context, new File(filePath), bitmap);
    }

    @Deprecated
    public static boolean saveBitmap(Context context, File imageFile, Bitmap bitmap) {
        ImageUtils.saveBitmapAsync(context, imageFile, bitmap);
        return true;
    }

    public static void saveBitmapAsync(final Context context, final File imageFile, final Bitmap bitmap) {
        try {
            if (bitmap == null || !ImageUtils.checkInternalStorageAvailability(context) && !ImageUtils.checkBuildImageFileDirectory(context, imageFile)) {
                return;
            }
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        File temp = new FileCache(context).getFile(System.currentTimeMillis() + "_temp_" + imageFile.getAbsolutePath());
                        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)new FileOutputStream(temp));
                        temp.renameTo(imageFile);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }).start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static boolean checkInternalStorageAvailability(Context context) {
        if (Environment.getExternalStorageState().equals("mounted_ro") || Environment.getExternalStorageState().equals("mounted")) {
            return true;
        }
        Toast.makeText((Context)context, (CharSequence)"Can't save image while media is mounted!", (int)1).show();
        return false;
    }

    private static boolean checkBuildImageFileDirectory(Context context, File imageFile) throws Exception {
        if (imageFile.exists() || imageFile.getParentFile().mkdirs() || imageFile.createNewFile()) {
            return true;
        }
        Toast.makeText((Context)context, (CharSequence)"Couldn't build image directory!", (int)1).show();
        return false;
    }

    public static void copyStream(InputStream is, OutputStream os) {
        int buffer_size = 1024;
        try {
            int count;
            byte[] bytes = new byte[1024];
            while ((count = is.read(bytes, 0, 1024)) != -1) {
                os.write(bytes, 0, count);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Bitmap decodeFile(File file, int requiredWidth) {
        if (file.getName().toLowerCase(Locale.US).endsWith(".svg")) {
            return ImageUtils.decodeSvgFile(file, requiredWidth);
        }
        return ImageUtils.decodeBitmapFile(file, requiredWidth, 1);
    }

    public static Bitmap decodeSVGAsset(Context context, String assetFileName) {
        return ImageUtils.decodeSVGAsset(context, assetFileName, -1);
    }

    public static Bitmap decodeSVGAsset(Context context, String assetFileName, int requiredWidth) {
        try {
            SVG svg = SVG.getFromAsset((AssetManager)context.getAssets(), (String)assetFileName);
            return ImageUtils.decodeBitmap(svg, requiredWidth);
        }
        catch (OutOfMemoryError e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static Bitmap decodeSvgFile(File file, int requiredWidth) {
        try {
            FileInputStream stream = new FileInputStream(file);
            Bitmap bitmap = ImageUtils.decodeBitmap(SVG.getFromInputStream((InputStream)stream), requiredWidth);
            stream.close();
            return bitmap;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Bitmap decodeBitmap(SVG svg, int requiredWidth) {
        if (svg.getDocumentWidth() != -1.0f) {
            if (requiredWidth < 1) {
                requiredWidth = (int)svg.getDocumentWidth();
            }
            float scaleFactor = (float)requiredWidth / svg.getDocumentWidth();
            int adjustedHeight = (int)(scaleFactor * svg.getDocumentHeight());
            Bitmap newBitmap = Bitmap.createBitmap((int)requiredWidth, (int)adjustedHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(newBitmap);
            canvas.drawPicture(svg.renderToPicture(), new Rect(0, 0, requiredWidth, adjustedHeight));
            return newBitmap;
        }
        return null;
    }

    private static Bitmap decodeBitmapFile(File file, int requiredWidth, int reductionFactor) {
        try {
            int inSampleSize;
            BitmapFactory.Options o = new BitmapFactory.Options();
            o.inJustDecodeBounds = true;
            FileInputStream stream = new FileInputStream(file);
            BitmapFactory.decodeStream((InputStream)stream, null, (BitmapFactory.Options)o);
            stream.close();
            o.inSampleSize = inSampleSize = ImageUtils.calculateInSampleSize(o, requiredWidth, reductionFactor);
            o.inJustDecodeBounds = false;
            stream = new FileInputStream(file);
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)stream, null, (BitmapFactory.Options)o);
            stream.close();
            return bitmap;
        }
        catch (OutOfMemoryError e) {
            e.printStackTrace();
            System.gc();
            return reductionFactor < 16 ? ImageUtils.decodeBitmapFile(file, requiredWidth, reductionFactor < 1 ? 2 : reductionFactor * 2) : null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Bitmap decodeBitmapResource(Resources resources, int resId, int requiredWidth) {
        return ImageUtils.decodeBitmapResource(resources, resId, requiredWidth, 1);
    }

    public static Bitmap decodeBitmapResource(Resources resources, int resId, int requiredWidth, int reductionFactor) {
        try {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeResource((Resources)resources, (int)resId, (BitmapFactory.Options)options);
            options.inSampleSize = ImageUtils.calculateInSampleSize(options, requiredWidth, reductionFactor);
            options.inJustDecodeBounds = false;
            return BitmapFactory.decodeResource((Resources)resources, (int)resId, (BitmapFactory.Options)options);
        }
        catch (OutOfMemoryError e) {
            e.printStackTrace();
            System.gc();
            return reductionFactor < 16 ? ImageUtils.decodeBitmapResource(resources, resId, requiredWidth, reductionFactor < 1 ? 2 : reductionFactor * 2) : null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int calculateInSampleSize(BitmapFactory.Options options, int requiredWidth, int reductionFactor) {
        int inSampleSize = 1;
        if (1 < requiredWidth && requiredWidth < options.outWidth) {
            while (options.outWidth / inSampleSize > requiredWidth) {
                inSampleSize *= 2;
            }
        }
        return inSampleSize * reductionFactor;
    }

    public static StateListDrawable buildStateListDrawable(Context context, SVG svgAssetNormal, SVG svgAssetPressed) {
        return ImageUtils.buildStateListDrawable((Drawable)ImageUtils.buildBitmapDrawable(context, svgAssetNormal), (Drawable)ImageUtils.buildBitmapDrawable(context, svgAssetPressed));
    }

    public static StateListDrawable buildStateListDrawable(Drawable dNormal, Drawable dPressed) {
        StateListDrawable states = new StateListDrawable();
        states.addState(new int[]{16842919}, dPressed);
        states.addState(new int[0], dNormal);
        return states;
    }

    public static BitmapDrawable buildBitmapDrawable(Context context, SVG svg) {
        return new BitmapDrawable(context.getResources(), ImageUtils.decodeBitmap(svg, (int)svg.getDocumentWidth()));
    }

    public static void log(Context context, String message) {
        if (context.getResources().getBoolean(R.bool.ail__debug_log_enabled)) {
            Log.d((String)TAG, (String)message);
        }
    }
}

