/*
 * Decompiled with CFR 0.152.
 */
package com.guardanis.imageloader.transitions.drawables;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;

public abstract class TransitionDrawable
extends BitmapDrawable {
    protected int duration;
    protected Drawable stubDrawable;
    protected TransitionStage transitionStage = TransitionStage.AWAITING_START;
    protected long animationStart;

    public TransitionDrawable(Context context, Drawable from, Bitmap to, int duration) {
        super(context.getResources(), to);
        this.stubDrawable = from;
        this.duration = duration;
    }

    public void start() {
        this.transitionStage = TransitionStage.TRANSITIONING;
        this.animationStart = System.currentTimeMillis();
        this.invalidateSelf();
    }

    public void draw(Canvas canvas) {
        if (this.transitionStage == TransitionStage.TRANSITIONING) {
            float normalized = (float)(System.currentTimeMillis() - this.animationStart) / (float)this.duration;
            if (1.0f <= normalized) {
                this.transitionStage = TransitionStage.FINISHED;
                this.stubDrawable = null;
                super.draw(canvas);
            } else {
                if (this.stubDrawable != null) {
                    this.drawStub(canvas, normalized);
                }
                this.drawForegroundTransition(canvas, normalized);
            }
        } else if (this.transitionStage == TransitionStage.AWAITING_START) {
            if (this.stubDrawable != null) {
                this.drawStub(canvas, 0.0f);
            }
        } else {
            super.draw(canvas);
        }
    }

    private void drawStub(Canvas canvas, float normalizedPercentCompleted) {
        canvas.save();
        int halfXDistance = (Math.max(this.getBounds().right, this.stubDrawable.getBounds().right) - Math.min(this.getBounds().right, this.stubDrawable.getBounds().right)) / 2;
        if (this.getBounds().right < this.stubDrawable.getBounds().right) {
            halfXDistance *= -1;
        }
        int halfYDistance = (Math.max(this.getBounds().bottom, this.stubDrawable.getBounds().bottom) - Math.min(this.getBounds().bottom, this.stubDrawable.getBounds().bottom)) / 2;
        if (this.getBounds().bottom < this.stubDrawable.getBounds().bottom) {
            halfYDistance *= -1;
        }
        canvas.translate((float)halfXDistance, (float)halfYDistance);
        this.drawBackgroundTransition(canvas, normalizedPercentCompleted);
        canvas.restore();
    }

    protected abstract void drawBackgroundTransition(Canvas var1, float var2);

    protected abstract void drawForegroundTransition(Canvas var1, float var2);

    protected void drawSuper(Canvas canvas) {
        super.draw(canvas);
    }

    protected static enum TransitionStage {
        AWAITING_START,
        TRANSITIONING,
        FINISHED;

    }
}

