/*
 * Decompiled with CFR 0.152.
 */
package com.guardanis.imageloader.transitions.drawables;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.drawable.Drawable;
import android.os.Build;
import com.guardanis.imageloader.transitions.drawables.TransitionDrawable;

public class FadingTransitionDrawable
extends TransitionDrawable {
    protected final int MAX_ALPHA = 255;
    protected final int TRANSITION_OUT_SPEED_MULTIPLIER = 2;
    protected int alpha = 255;
    protected int stubStartingAlpha = 255;

    @SuppressLint(value={"NewApi"})
    public FadingTransitionDrawable(Context context, Drawable from, Bitmap to, int fadeDuration) {
        super(context, from, to, fadeDuration);
        if (19 <= Build.VERSION.SDK_INT && from != null) {
            this.stubStartingAlpha = from.getAlpha();
        }
    }

    @Override
    protected void drawBackgroundTransition(Canvas canvas, float normalizedPercentCompleted) {
        this.stubDrawable.setAlpha((int)Math.max(255.0f - (float)this.stubStartingAlpha * normalizedPercentCompleted * 2.0f, 0.0f));
        this.stubDrawable.draw(canvas);
        this.stubDrawable.setAlpha(this.stubStartingAlpha);
    }

    @Override
    protected void drawForegroundTransition(Canvas canvas, float normalizedPercentCompleted) {
        super.setAlpha((int)((float)this.alpha * normalizedPercentCompleted));
        this.drawSuper(canvas);
        super.setAlpha(this.alpha);
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }

    public void setColorFilter(ColorFilter cf) {
    }

    public int getOpacity() {
        return 1;
    }
}

