/*
 * Decompiled with CFR 0.152.
 */
package com.guardanis.imageloader;

import android.content.Context;
import android.os.Environment;
import java.io.File;

public class FileCache {
    private File cacheDir;

    public FileCache(Context context) {
        this.cacheDir = Environment.getExternalStorageState().equals("mounted") ? new File(Environment.getExternalStorageDirectory(), context.getPackageName()) : context.getCacheDir();
        if (!this.cacheDir.exists()) {
            this.cacheDir.mkdirs();
        }
    }

    public File getFile(String url) {
        String filename = String.valueOf(url.hashCode()) + (url.endsWith("svg") ? ".svg" : "");
        return new File(this.cacheDir, filename);
    }

    public void clear() {
        File[] files = this.cacheDir.listFiles();
        if (files != null) {
            for (File file : files) {
                file.delete();
            }
        }
    }

    public static void clear(Context context) {
        new FileCache(context).clear();
    }
}

