/*
 * Decompiled with CFR 0.152.
 */
package com.guardanis.imageloader.transitions;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.v4.content.ContextCompat;
import android.widget.ImageView;
import com.guardanis.imageloader.ImageRequest;
import com.guardanis.imageloader.R;
import com.guardanis.imageloader.transitions.drawables.TransitionDrawable;

public abstract class TransitionController {
    protected ImageRequest request;

    public TransitionController(ImageRequest request) {
        this.request = request;
    }

    public void transitionTo(Drawable to) {
        this.performTransition(to);
    }

    protected abstract void performTransition(Drawable var1);

    protected Drawable getCurrentTargetDrawable() {
        Drawable current = this.request.isRequestForBackgroundImage() ? this.request.getTargetView().getBackground() : ((ImageView)this.request.getTargetView()).getDrawable();
        return current == null ? ContextCompat.getDrawable((Context)this.request.getContext(), (int)R.drawable.ail__default_fade_placeholder) : current;
    }

    protected Drawable getCurrentTargetDrawableMutable() {
        return this.getCurrentTargetDrawable().getConstantState().newDrawable().mutate();
    }

    protected Bitmap getTargetBitmap(Drawable drawable2) {
        if (drawable2 instanceof BitmapDrawable) {
            return ((BitmapDrawable)drawable2).getBitmap();
        }
        Bitmap bitmap = null;
        if (drawable2.getIntrinsicWidth() < 1 || drawable2.getIntrinsicHeight() < 1) {
            bitmap = Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        } else {
            Bitmap.createBitmap((int)drawable2.getIntrinsicWidth(), (int)drawable2.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        Canvas canvas = new Canvas(bitmap);
        drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable2.draw(canvas);
        return bitmap;
    }

    protected void setTransitionDrawable(TransitionDrawable drawable2) {
        if (this.request.isRequestForBackgroundImage()) {
            this.setBackgroundDrawable((Drawable)drawable2);
        } else {
            ((ImageView)this.request.getTargetView()).setImageDrawable((Drawable)drawable2);
        }
        drawable2.start();
    }

    protected void setTargetViewDrawable(final Drawable drawable2) {
        this.request.getTargetView().post(new Runnable(){

            @Override
            public void run() {
                if (TransitionController.this.request.isRequestForBackgroundImage()) {
                    TransitionController.this.setBackgroundDrawable(drawable2);
                } else {
                    ((ImageView)TransitionController.this.request.getTargetView()).setImageDrawable(drawable2);
                }
            }
        });
    }

    @SuppressLint(value={"NewApi"})
    protected void setBackgroundDrawable(Drawable drawable2) {
        if (Build.VERSION.SDK_INT < 16) {
            this.request.getTargetView().setBackgroundDrawable(drawable2);
        } else {
            this.request.getTargetView().setBackground(drawable2);
        }
    }
}

