/*
 * Decompiled with CFR 0.152.
 */
package com.guardanis.imageloader;

import android.os.Handler;
import com.guardanis.imageloader.ImageLoader;
import com.guardanis.imageloader.ImageRequest;
import com.guardanis.imageloader.ImageUtils;
import java.io.File;

public class ImageDownloader
implements Runnable {
    protected ImageRequest imageRequest;
    protected DownloadEventListener downloadEventListener;
    protected Handler handler;

    public ImageDownloader(Handler handler, ImageRequest imageRequest, DownloadEventListener downloadEventListener) {
        this.handler = handler;
        this.imageRequest = imageRequest;
        this.downloadEventListener = downloadEventListener;
    }

    @Override
    public void run() {
        try {
            File downloadedFile = ImageLoader.getInstance(this.imageRequest.getContext()).download(this.imageRequest.getTargetUrl(), this.imageRequest.getOriginalRequestFile());
            if (downloadedFile != null) {
                this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        ImageUtils.log(ImageDownloader.this.imageRequest.getContext(), "Download success: " + ImageDownloader.this.imageRequest.getTargetUrl());
                        ImageDownloader.this.downloadEventListener.onDownloadCompleted(ImageDownloader.this, ImageDownloader.this.imageRequest.getTargetUrl());
                    }
                });
                return;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                ImageUtils.log(ImageDownloader.this.imageRequest.getContext(), "Download failed: " + ImageDownloader.this.imageRequest.getTargetUrl());
                ImageDownloader.this.downloadEventListener.onDownloadFailed(ImageDownloader.this, ImageDownloader.this.imageRequest.getTargetUrl());
            }
        });
    }

    public static interface DownloadEventListener {
        public void onDownloadCompleted(ImageDownloader var1, String var2);

        public void onDownloadFailed(ImageDownloader var1, String var2);
    }
}

