/*
 * Decompiled with CFR 0.152.
 */
package com.guardanis.imageloader;

import android.os.Handler;
import android.util.Log;
import com.guardanis.imageloader.ImageLoader;
import com.guardanis.imageloader.ImageRequest;
import java.io.File;

public class ImageDownloadRequest
implements Runnable {
    private static final String TAG = "AIL__download_request";
    protected ImageRequest imageRequest;
    protected DownloadEventListener downloadEventListener;
    protected Handler handler;

    public ImageDownloadRequest(Handler handler, ImageRequest imageRequest, DownloadEventListener downloadEventListener) {
        this.handler = handler;
        this.imageRequest = imageRequest;
        this.downloadEventListener = downloadEventListener;
    }

    @Override
    public void run() {
        try {
            File downloadedFile = ImageLoader.getInstance(this.imageRequest.getContext()).download(this.imageRequest.getTargetUrl(), this.imageRequest.getOriginalRequestFile());
            if (downloadedFile != null) {
                this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        Log.d((String)ImageDownloadRequest.TAG, (String)("Download success: " + ImageDownloadRequest.this.imageRequest.getTargetUrl()));
                        ImageDownloadRequest.this.downloadEventListener.onDownloadCompleted(ImageDownloadRequest.this, ImageDownloadRequest.this.imageRequest.getTargetUrl());
                    }
                });
                return;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                Log.d((String)ImageDownloadRequest.TAG, (String)("Download failed: " + ImageDownloadRequest.this.imageRequest.getTargetUrl()));
                ImageDownloadRequest.this.downloadEventListener.onDownloadFailed(ImageDownloadRequest.this, ImageDownloadRequest.this.imageRequest.getTargetUrl());
            }
        });
    }

    public static interface DownloadEventListener {
        public void onDownloadCompleted(ImageDownloadRequest var1, String var2);

        public void onDownloadFailed(ImageDownloadRequest var1, String var2);
    }
}

