/*
 * Decompiled with CFR 0.152.
 */
package com.guardanis.imageloader;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.View;
import android.widget.ImageView;
import com.guardanis.imageloader.ImageLoader;
import com.guardanis.imageloader.ImageUtils;
import com.guardanis.imageloader.StubHolder;
import com.guardanis.imageloader.filters.BitmapBlurFilter;
import com.guardanis.imageloader.filters.BitmapCircularCropFilter;
import com.guardanis.imageloader.filters.BitmapColorOverlayFilter;
import com.guardanis.imageloader.filters.BitmapRotationFilter;
import com.guardanis.imageloader.filters.ImageFilter;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class ImageRequest<V extends View>
implements Runnable {
    protected static final int DEFAULT_BLUR_RADIUS = 15;
    protected Context context;
    protected String targetUrl;
    protected V targetView;
    protected boolean setImageAsBackground = false;
    protected List<ImageFilter<Bitmap>> bitmapImageFilters = new ArrayList<ImageFilter<Bitmap>>();
    protected boolean showStubOnExecute = true;
    protected boolean showStubOnError = false;
    protected StubHolder stubHolder;

    public ImageRequest(Context context) {
        this(context, "");
    }

    public ImageRequest(Context context, String targetUrl) {
        this.context = context;
        this.targetUrl = targetUrl;
    }

    public ImageRequest<V> setTargetUrl(String targetUrl) {
        this.targetUrl = targetUrl;
        return this;
    }

    public ImageRequest<V> setTargetView(V targetView) {
        this.targetView = targetView;
        return this;
    }

    public ImageRequest<V> setImageAsBackground() {
        this.setImageAsBackground = true;
        return this;
    }

    public ImageRequest<V> setImageAsBackground(boolean setImageAsBackground) {
        this.setImageAsBackground = setImageAsBackground;
        return this;
    }

    public ImageRequest<V> setShowStubOnExecute(boolean showStubOnExecute) {
        this.showStubOnExecute = showStubOnExecute;
        return this;
    }

    public ImageRequest<V> setShowStubOnError(boolean showStubOnError) {
        this.showStubOnError = showStubOnError;
        return this;
    }

    public ImageRequest<V> addBlurFilter() {
        return this.addBlurFilter(15);
    }

    public ImageRequest<V> addBlurFilter(int blurRadius) {
        this.bitmapImageFilters.add(new BitmapBlurFilter(this.context, blurRadius));
        return this;
    }

    public ImageRequest<V> addColorOverlayFilter(int colorOverlay) {
        this.bitmapImageFilters.add(new BitmapColorOverlayFilter(this.context, colorOverlay));
        return this;
    }

    public ImageRequest<V> addRotationFilter(int rotationDegrees) {
        this.bitmapImageFilters.add(new BitmapRotationFilter(this.context, rotationDegrees));
        return this;
    }

    public ImageRequest<V> addCircularCropFilter() {
        this.bitmapImageFilters.add(new BitmapCircularCropFilter(this.context));
        return this;
    }

    public ImageRequest<V> addImageFilter(ImageFilter<Bitmap> imageFilter) {
        this.bitmapImageFilters.add(imageFilter);
        return this;
    }

    public ImageRequest<V> overrideStubs(StubHolder stubHolder) {
        this.stubHolder = stubHolder;
        return this;
    }

    @Override
    public void run() {
        if (this.targetView != null) {
            this.performFullImageRequest();
        }
    }

    protected void performFullImageRequest() {
        int requiredImageWidth = this.targetView.getLayoutParams().width;
        File imageFile = this.getEditedRequestFile();
        if (!imageFile.exists()) {
            File originalImageFile = this.getOriginalRequestFile();
            if (!originalImageFile.exists()) {
                this.onRequestFailed();
            } else {
                this.processImage(imageFile, ImageUtils.decodeFile(originalImageFile, requiredImageWidth));
            }
        } else {
            this.onRequestSuccessful(ImageUtils.decodeFile(imageFile, requiredImageWidth));
        }
    }

    protected void processImage(File imageFile, Bitmap bitmap) {
        if (0 < this.bitmapImageFilters.size()) {
            bitmap = this.applyBitmapFilters(bitmap);
            this.saveBitmap(imageFile, bitmap);
        }
        this.onRequestSuccessful(bitmap);
    }

    protected Bitmap applyBitmapFilters(Bitmap bitmap) {
        for (ImageFilter<Bitmap> filter : this.bitmapImageFilters) {
            bitmap = filter.filter(bitmap);
        }
        return bitmap;
    }

    protected void saveBitmap(File imageFile, Bitmap bitmap) {
        ImageUtils.saveBitmap(this.context, imageFile, bitmap);
    }

    protected void onRequestSuccessful(final Bitmap bitmap) {
        if (this.targetView == null || !ImageLoader.getInstance(this.context).isViewStillUsable((View)this.targetView, this.targetUrl)) {
            return;
        }
        try {
            this.targetView.post(new Runnable(){

                @Override
                public void run() {
                    if (ImageRequest.this.targetView instanceof ImageView && !ImageRequest.this.setImageAsBackground) {
                        ((ImageView)ImageRequest.this.targetView).setImageBitmap(bitmap);
                    } else {
                        ImageRequest.this.setBackgroundDrawable((View)ImageRequest.this.targetView, (Drawable)new BitmapDrawable(ImageRequest.this.targetView.getContext().getResources(), bitmap));
                    }
                }
            });
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    protected void onRequestFailed() {
        if (this.targetView == null || !ImageLoader.getInstance(this.context).isViewStillUsable((View)this.targetView, this.targetUrl)) {
            return;
        }
        if (this.showStubOnError) {
            this.setTargetViewDrawable(this.getStubs().getErrorDrawable(this.context));
        } else {
            this.setTargetViewDrawable(null);
        }
    }

    protected String getFullRequestFileCacheName() {
        String adjustedName = this.targetUrl;
        for (ImageFilter<Bitmap> filter : this.bitmapImageFilters) {
            adjustedName = adjustedName + "_" + filter.getAdjustmentInfo();
        }
        return adjustedName;
    }

    protected File getEditedRequestFile() {
        return ImageLoader.getInstance(this.context).getFileCache().getFile(this.getFullRequestFileCacheName());
    }

    protected String getOriginalRequestFileCacheName() {
        return this.targetUrl;
    }

    public Context getContext() {
        return this.context;
    }

    public File getOriginalRequestFile() {
        return ImageLoader.getInstance(this.context).getFileCache().getFile(this.getOriginalRequestFileCacheName());
    }

    protected void setTargetViewDrawable(final Drawable drawable2) {
        this.targetView.post(new Runnable(){

            @Override
            public void run() {
                if (ImageRequest.this.targetView instanceof ImageView && !ImageRequest.this.setImageAsBackground) {
                    ((ImageView)ImageRequest.this.targetView).setImageDrawable(drawable2);
                } else {
                    ImageRequest.this.setBackgroundDrawable((View)ImageRequest.this.targetView, drawable2);
                }
            }
        });
    }

    @SuppressLint(value={"NewApi"})
    protected void setBackgroundDrawable(View v, Drawable drawable2) {
        if (Build.VERSION.SDK_INT < 16) {
            v.setBackgroundDrawable(drawable2);
        } else {
            v.setBackground(drawable2);
        }
    }

    protected StubHolder getStubs() {
        if (this.stubHolder == null) {
            return ImageLoader.getInstance(this.context).getStubs();
        }
        return this.stubHolder;
    }

    public String getTargetUrl() {
        return this.targetUrl;
    }

    public void execute() {
        if (this.targetView == null) {
            ImageLoader.getInstance(this.context).submit(this);
        } else {
            this.targetView.post(new Runnable(){

                @Override
                public void run() {
                    ImageLoader.getInstance(ImageRequest.this.context).addViewAndTargetUrl((View)ImageRequest.this.targetView, ImageRequest.this.targetUrl);
                    if (ImageRequest.this.showStubOnExecute) {
                        ImageRequest.this.setTargetViewDrawable(ImageRequest.this.getStubs().getLoadingDrawable(ImageRequest.this.context));
                    } else {
                        ImageRequest.this.setTargetViewDrawable(null);
                    }
                    ImageLoader.getInstance(ImageRequest.this.context).submit(ImageRequest.this);
                }
            });
        }
    }
}

