/*
 * Decompiled with CFR 0.152.
 */
package com.guardanis.imageloader.transitions.drawables;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import com.guardanis.imageloader.stubs.AnimatedStubDrawable;
import com.guardanis.imageloader.stubs.StubDrawable;

public abstract class TransitionDrawable
extends BitmapDrawable {
    protected int duration;
    protected Drawable stubDrawable;
    protected Drawable postTransitionDrawable;
    protected TransitionStage transitionStage = TransitionStage.AWAITING_START;
    protected long animationStart;

    public TransitionDrawable(Context context, Drawable from, Bitmap to, int duration) {
        this(context, from, to, null, duration);
    }

    public TransitionDrawable(Context context, Drawable from, Bitmap to, Drawable postTransitionDrawable, int duration) {
        super(context.getResources(), to);
        this.stubDrawable = from;
        this.postTransitionDrawable = postTransitionDrawable;
        this.duration = duration;
    }

    public void start() {
        this.transitionStage = TransitionStage.TRANSITIONING;
        this.animationStart = System.currentTimeMillis();
        this.invalidateSelf();
    }

    public void draw(Canvas canvas) {
        if (this.transitionStage == TransitionStage.TRANSITIONING) {
            float normalized = (float)(System.currentTimeMillis() - this.animationStart) / (float)this.duration;
            if (1.0f <= normalized) {
                this.transitionStage = TransitionStage.FINISHED;
                this.stubDrawable = null;
                this.handlePostTransitionDrawing(canvas);
            } else {
                if (this.stubDrawable != null) {
                    this.drawStub(canvas, normalized);
                }
                this.drawForegroundTransition(canvas, normalized);
            }
        } else if (this.transitionStage == TransitionStage.AWAITING_START) {
            if (this.stubDrawable != null) {
                this.drawStub(canvas, 0.0f);
            }
        } else {
            this.handlePostTransitionDrawing(canvas);
        }
    }

    protected void drawStub(Canvas canvas, float normalizedPercentCompleted) {
        canvas.save();
        int[] translation = this.calculateStubTranslation(this.stubDrawable);
        canvas.translate((float)translation[0], (float)translation[1]);
        this.drawBackgroundTransition(canvas, normalizedPercentCompleted);
        canvas.restore();
    }

    protected void handlePostTransitionDrawing(Canvas canvas) {
        if (this.isTargetStubDrawable()) {
            this.postTransitionDrawable.draw(canvas);
            if (this.postTransitionDrawable instanceof AnimatedStubDrawable) {
                this.invalidateSelf();
            }
        } else {
            super.draw(canvas);
        }
    }

    protected int[] calculateStubTranslation(Drawable drawable2) {
        int halfXDistance = (Math.max(this.getBounds().right, drawable2.getBounds().right) - Math.min(this.getBounds().right, drawable2.getBounds().right)) / 2;
        if (this.getBounds().right < drawable2.getBounds().right) {
            halfXDistance *= -1;
        }
        int halfYDistance = (Math.max(this.getBounds().bottom, drawable2.getBounds().bottom) - Math.min(this.getBounds().bottom, drawable2.getBounds().bottom)) / 2;
        if (this.getBounds().bottom < drawable2.getBounds().bottom) {
            halfYDistance *= -1;
        }
        return new int[]{halfXDistance, halfYDistance};
    }

    protected abstract void drawBackgroundTransition(Canvas var1, float var2);

    protected abstract void drawForegroundTransition(Canvas var1, float var2);

    protected void drawSuper(Canvas canvas) {
        if (this.isTargetStubDrawable()) {
            this.postTransitionDrawable.draw(canvas);
        } else {
            super.draw(canvas);
        }
    }

    public void setAlpha(int alpha) {
        super.setAlpha(alpha);
        if (this.isTargetStubDrawable()) {
            this.postTransitionDrawable.setAlpha(alpha);
        }
    }

    protected boolean isTargetStubDrawable() {
        return this.postTransitionDrawable != null && (this.postTransitionDrawable instanceof AnimatedStubDrawable || this.postTransitionDrawable instanceof StubDrawable);
    }

    protected static enum TransitionStage {
        AWAITING_START,
        TRANSITIONING,
        FINISHED;

    }
}

