/*
 * Decompiled with CFR 0.152.
 */
package com.guardanis.imageloader.filters;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.Rect;
import com.guardanis.imageloader.filters.ImageFilter;

public class BitmapCircularCropFilter
extends ImageFilter<Bitmap> {
    public BitmapCircularCropFilter(Context context) {
        super(context);
    }

    @Override
    public Bitmap filter(Bitmap unedited) {
        Bitmap cropped = Bitmap.createBitmap((int)unedited.getWidth(), (int)unedited.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(cropped);
        canvas.clipPath(this.getCircularClippingPath(unedited));
        canvas.drawBitmap(unedited, new Rect(0, 0, unedited.getWidth(), unedited.getHeight()), new Rect(0, 0, unedited.getWidth(), unedited.getHeight()), null);
        return cropped;
    }

    private Path getCircularClippingPath(Bitmap bitmap) {
        int targetRadius = (int)((float)Math.min(bitmap.getWidth(), bitmap.getHeight()) / 2.0f) - 1;
        Path path = new Path();
        path.addCircle((float)(bitmap.getWidth() - 1) / 2.0f, (float)(bitmap.getHeight() - 1) / 2.0f, (float)targetRadius, Path.Direction.CCW);
        return path;
    }
}

