/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.monitor.marshaller.json;

import com.growingio.android.sdk.monitor.event.interfaces.MonitorStackTraceElement;
import com.growingio.android.sdk.monitor.event.interfaces.StackTraceInterface;
import com.growingio.android.sdk.monitor.marshaller.json.InterfaceBinding;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class StackTraceInterfaceBinding
implements InterfaceBinding<StackTraceInterface> {
    private static final String STACKTRACE_PARAMETER = "stacktrace";
    private static final String FRAMES_PARAMETER = "frames";
    private static final String FILENAME_PARAMETER = "filename";
    private static final String FUNCTION_PARAMETER = "function";
    private static final String MODULE_PARAMETER = "module";
    private static final String LINE_NO_PARAMETER = "lineno";
    private static final String IN_APP_PARAMETER = "in_app";
    private static List<Pattern> inAppBlacklistRegexps = new ArrayList<Pattern>();
    private Collection<String> inAppFrames = Collections.emptyList();
    private boolean removeCommonFramesWithEnclosing = true;

    private JSONObject getFrameJsonObject(MonitorStackTraceElement stackTraceElement, boolean commonWithEnclosing) throws JSONException {
        JSONObject frameJson = new JSONObject();
        frameJson.put(FILENAME_PARAMETER, (Object)stackTraceElement.getFileName());
        frameJson.put(MODULE_PARAMETER, (Object)stackTraceElement.getModule());
        boolean inApp = (!this.removeCommonFramesWithEnclosing || !commonWithEnclosing) && this.isFrameInApp(stackTraceElement);
        frameJson.put(IN_APP_PARAMETER, inApp);
        frameJson.put(FUNCTION_PARAMETER, (Object)stackTraceElement.getFunction());
        frameJson.put(LINE_NO_PARAMETER, stackTraceElement.getLineno());
        return frameJson;
    }

    private boolean isFrameInApp(MonitorStackTraceElement stackTraceElement) {
        for (String inAppFrame : this.inAppFrames) {
            String className = stackTraceElement.getModule();
            if (!className.startsWith(inAppFrame) || this.isBlacklistedFromInApp(className)) continue;
            return true;
        }
        return false;
    }

    private boolean isBlacklistedFromInApp(String className) {
        for (Pattern inAppBlacklistRegexp : inAppBlacklistRegexps) {
            boolean found = inAppBlacklistRegexp.matcher(className).find();
            if (!found) continue;
            return true;
        }
        return false;
    }

    @Override
    public void writeInterface(JSONObject generator, StackTraceInterface monitorInterface) throws JSONException {
        JSONArray stackTraceJson = new JSONArray();
        MonitorStackTraceElement[] monitorStackTrace = monitorInterface.getStackTrace();
        int commonWithEnclosing = monitorInterface.getFramesCommonWithEnclosing();
        for (int i = monitorStackTrace.length - 1; i >= 0; --i) {
            stackTraceJson.put((Object)this.getFrameJsonObject(monitorStackTrace[i], commonWithEnclosing-- > 0));
        }
        generator.put(STACKTRACE_PARAMETER, (Object)new JSONObject().put(FRAMES_PARAMETER, (Object)stackTraceJson));
    }

    public void setRemoveCommonFramesWithEnclosing(boolean removeCommonFramesWithEnclosing) {
        this.removeCommonFramesWithEnclosing = removeCommonFramesWithEnclosing;
    }

    public void setInAppFrames(Collection<String> inAppFrames) {
        this.inAppFrames = inAppFrames;
    }

    static {
        inAppBlacklistRegexps.add(Pattern.compile("\\$\\$FastClass[a-zA-Z]*CGLIB\\$\\$"));
        inAppBlacklistRegexps.add(Pattern.compile("\\$\\$Enhancer[a-zA-Z]*CGLIB\\$\\$"));
    }
}

