/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.monitor.marshaller.json;

import com.growingio.android.sdk.monitor.event.interfaces.MessageInterface;
import com.growingio.android.sdk.monitor.marshaller.json.InterfaceBinding;
import com.growingio.android.sdk.monitor.util.Util;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MessageInterfaceBinding
implements InterfaceBinding<MessageInterface> {
    public static final int DEFAULT_MAX_MESSAGE_LENGTH = 1000;
    private static final String MESSAGE_PARAMETER = "message";
    private static final String PARAMS_PARAMETER = "params";
    private static final String FORMATTED_PARAMETER = "formatted";
    private final int maxMessageLength;

    public MessageInterfaceBinding() {
        this.maxMessageLength = 1000;
    }

    public MessageInterfaceBinding(int maxMessageLength) {
        this.maxMessageLength = maxMessageLength;
    }

    @Override
    public void writeInterface(JSONObject generator, MessageInterface monitorInterface) throws JSONException {
        JSONObject messageJson = new JSONObject();
        messageJson.put(MESSAGE_PARAMETER, (Object)Util.trimString(monitorInterface.getMessage(), this.maxMessageLength));
        JSONArray params = new JSONArray();
        for (String parameter : monitorInterface.getParameters()) {
            params.put((Object)parameter);
        }
        messageJson.put(PARAMS_PARAMETER, (Object)params);
        if (monitorInterface.getFormatted() != null) {
            messageJson.put(FORMATTED_PARAMETER, (Object)Util.trimString(monitorInterface.getFormatted(), this.maxMessageLength));
        }
        generator.put(monitorInterface.getInterfaceName(), (Object)messageJson);
    }
}

