/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.monitor.marshaller.json;

import com.growingio.android.sdk.monitor.event.Breadcrumb;
import com.growingio.android.sdk.monitor.event.Event;
import com.growingio.android.sdk.monitor.event.MonitorSdk;
import com.growingio.android.sdk.monitor.event.interfaces.MonitorInterface;
import com.growingio.android.sdk.monitor.log.MLog;
import com.growingio.android.sdk.monitor.marshaller.json.InterfaceBinding;
import com.growingio.android.sdk.monitor.util.Util;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonMarshaller {
    private static final String TAG = "JsonMarshaller";
    public static final String EVENT_ID = "event_id";
    public static final String MESSAGE = "message";
    public static final String TIMESTAMP = "timestamp";
    public static final String LEVEL = "level";
    public static final String PLATFORM = "platform";
    public static final String SDK = "sdk";
    public static final String TAGS = "tags";
    public static final String BREADCRUMBS = "breadcrumbs";
    public static final String CONTEXTS = "contexts";
    public static final String RELEASE = "release";
    public static final String DIST = "dist";
    public static final String ENVIRONMENT = "environment";
    public static final String EXTRA = "extra";
    public static final int DEFAULT_MAX_MESSAGE_LENGTH = 1000;
    private static final ThreadLocal<DateFormat> ISO_FORMAT = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.ENGLISH);
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            return dateFormat;
        }
    };
    private final Map<Class<? extends MonitorInterface>, InterfaceBinding<?>> interfaceBindings = new HashMap();
    private final int maxMessageLength;

    public JsonMarshaller() {
        this(1000);
    }

    public JsonMarshaller(int maxMessageLength) {
        this.maxMessageLength = maxMessageLength;
    }

    public JSONObject marshall(Event event) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        this.writeContent(jsonObject, event);
        return jsonObject;
    }

    private void writeContent(JSONObject generator, Event event) throws JSONException {
        generator.put(EVENT_ID, (Object)this.formatId(event.getId()));
        generator.put(MESSAGE, (Object)Util.trimString(event.getMessage(), this.maxMessageLength));
        generator.put(TIMESTAMP, (Object)ISO_FORMAT.get().format(event.getTimestamp()));
        generator.put(LEVEL, (Object)event.getLevel().toString());
        generator.put(PLATFORM, (Object)event.getPlatform());
        this.writeSdk(generator, event.getSdk());
        this.writeTags(generator, event.getTags());
        this.writeBreadcumbs(generator, event.getBreadcrumbs());
        this.writeContexts(generator, event.getContexts());
        generator.put(RELEASE, (Object)event.getRelease());
        generator.put(DIST, (Object)event.getDist());
        generator.put(ENVIRONMENT, (Object)event.getEnvironment());
        this.writeExtras(generator, event.getExtra());
        this.writeInterfaces(generator, event.getMonitorInterfaces());
    }

    private void writeInterfaces(JSONObject generator, Map<String, MonitorInterface> monitorInterfaces) throws JSONException {
        for (Map.Entry<String, MonitorInterface> interfaceEntry : monitorInterfaces.entrySet()) {
            MonitorInterface monitorInterface = interfaceEntry.getValue();
            if (this.interfaceBindings.containsKey(monitorInterface.getClass())) {
                this.getInterfaceBinding(monitorInterface).writeInterface(generator, interfaceEntry.getValue());
                continue;
            }
            MLog.e(TAG, "Couldn't parse the content of " + interfaceEntry.getKey() + " provided in " + monitorInterface);
        }
    }

    private <T extends MonitorInterface> InterfaceBinding<? super T> getInterfaceBinding(T monitorInterface) {
        return this.interfaceBindings.get(monitorInterface.getClass());
    }

    private void writeExtras(JSONObject generator, Map<String, Object> extras) throws JSONException {
        generator.put(EXTRA, (Object)new JSONObject(extras));
    }

    private void writeSdk(JSONObject generator, MonitorSdk sdk) throws JSONException {
        JSONObject sdkJson = new JSONObject();
        sdkJson.put("name", (Object)sdk.getName());
        sdkJson.put("version", (Object)sdk.getVersion());
        if (sdk.getIntegrations() != null && !sdk.getIntegrations().isEmpty()) {
            JSONArray integrations = new JSONArray();
            for (String integration : sdk.getIntegrations()) {
                integrations.put((Object)integration);
            }
            sdkJson.put("integrations", (Object)integrations);
        }
        generator.put(SDK, (Object)sdkJson);
    }

    private void writeTags(JSONObject generator, Map<String, String> tags) throws JSONException {
        generator.put(TAGS, (Object)new JSONObject(tags));
    }

    private void writeBreadcumbs(JSONObject generator, List<Breadcrumb> breadcrumbs) throws JSONException {
        if (breadcrumbs == null || breadcrumbs.isEmpty()) {
            return;
        }
        JSONObject breadcrumbsJson = new JSONObject();
        JSONArray values = new JSONArray();
        for (Breadcrumb breadcrumb : breadcrumbs) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put(TIMESTAMP, breadcrumb.getTimestamp().getTime() / 1000L);
            if (breadcrumb.getType() != null) {
                jsonObject.put("type", (Object)breadcrumb.getType().getValue());
            }
            if (breadcrumb.getLevel() != null) {
                jsonObject.put(LEVEL, (Object)breadcrumb.getLevel().getValue());
            }
            if (breadcrumb.getMessage() != null) {
                jsonObject.put(MESSAGE, (Object)breadcrumb.getMessage());
            }
            if (breadcrumb.getCategory() != null) {
                jsonObject.put("category", (Object)breadcrumb.getCategory());
            }
            if (breadcrumb.getData() != null && !breadcrumb.getData().isEmpty()) {
                jsonObject.put("data", (Object)new JSONObject(breadcrumb.getData()));
            }
            values.put((Object)jsonObject);
        }
        breadcrumbsJson.put("values", (Object)values);
        generator.put(BREADCRUMBS, (Object)breadcrumbsJson);
    }

    private void writeContexts(JSONObject generator, Map<String, Map<String, Object>> contexts) throws JSONException {
        if (contexts.isEmpty()) {
            return;
        }
        JSONObject contextJson = new JSONObject();
        for (Map.Entry<String, Map<String, Object>> entry : contexts.entrySet()) {
            contextJson.put(entry.getKey(), (Object)new JSONObject(entry.getValue()));
        }
        generator.put(CONTEXTS, (Object)contextJson);
    }

    private String formatId(UUID id) {
        return id.toString().replaceAll("-", "");
    }

    public <T extends MonitorInterface, F extends T> void addInterfaceBinding(Class<F> monitorInterfaceClass, InterfaceBinding<T> binding) {
        this.interfaceBindings.put(monitorInterfaceClass, binding);
    }
}

