/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.monitor.event.interfaces;

import com.growingio.android.sdk.monitor.event.interfaces.MonitorInterface;
import com.growingio.android.sdk.monitor.event.interfaces.MonitorStackTraceElement;
import com.growingio.android.sdk.monitor.jvmti.Frame;
import java.util.Arrays;

public class StackTraceInterface
implements MonitorInterface {
    public static final String STACKTRACE_INTERFACE = "sentry.interfaces.Stacktrace";
    private final MonitorStackTraceElement[] stackTrace;
    private final int framesCommonWithEnclosing;

    public StackTraceInterface(StackTraceElement[] stackTrace) {
        this(stackTrace, new StackTraceElement[0], null);
    }

    public StackTraceInterface(StackTraceElement[] stackTrace, StackTraceElement[] enclosingStackTrace) {
        this(stackTrace, enclosingStackTrace, null);
    }

    public StackTraceInterface(StackTraceElement[] stackTrace, StackTraceElement[] enclosingStackTrace, Frame[] cachedFrames) {
        this.stackTrace = MonitorStackTraceElement.fromStackTraceElements(stackTrace, cachedFrames);
        int m = stackTrace.length - 1;
        for (int n = enclosingStackTrace.length - 1; m >= 0 && n >= 0 && stackTrace[m].equals(enclosingStackTrace[n]); --m, --n) {
        }
        this.framesCommonWithEnclosing = stackTrace.length - 1 - m;
    }

    public StackTraceInterface(MonitorStackTraceElement[] stackTrace) {
        this.stackTrace = Arrays.copyOf(stackTrace, stackTrace.length);
        this.framesCommonWithEnclosing = 0;
    }

    @Override
    public String getInterfaceName() {
        return STACKTRACE_INTERFACE;
    }

    public MonitorStackTraceElement[] getStackTrace() {
        return Arrays.copyOf(this.stackTrace, this.stackTrace.length);
    }

    public int getFramesCommonWithEnclosing() {
        return this.framesCommonWithEnclosing;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StackTraceInterface that = (StackTraceInterface)o;
        return Arrays.equals(this.stackTrace, that.stackTrace);
    }

    public int hashCode() {
        return Arrays.hashCode(this.stackTrace);
    }

    public String toString() {
        return "StackTraceInterface{stackTrace=" + Arrays.toString(this.stackTrace) + '}';
    }
}

