/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.monitor.event.interfaces;

import com.growingio.android.sdk.monitor.jvmti.Frame;
import java.io.Serializable;
import java.util.Map;

public class MonitorStackTraceElement
implements Serializable {
    private final String module;
    private final String function;
    private final String fileName;
    private final int lineno;
    private final Integer colno;
    private final String absPath;
    private final String platform;
    private final Map<String, Object> locals;

    public MonitorStackTraceElement(String module, String function, String fileName, int lineno, Integer colno, String absPath, String platform) {
        this(module, function, fileName, lineno, colno, absPath, platform, null);
    }

    public MonitorStackTraceElement(String module, String function, String fileName, int lineno, Integer colno, String absPath, String platform, Map<String, Object> locals) {
        this.module = module;
        this.function = function;
        this.fileName = fileName;
        this.lineno = lineno;
        this.colno = colno;
        this.absPath = absPath;
        this.platform = platform;
        this.locals = locals;
    }

    public String getModule() {
        return this.module;
    }

    public String getFunction() {
        return this.function;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getLineno() {
        return this.lineno;
    }

    public Integer getColno() {
        return this.colno;
    }

    public String getAbsPath() {
        return this.absPath;
    }

    public String getPlatform() {
        return this.platform;
    }

    public Map<String, Object> getLocals() {
        return this.locals;
    }

    public static MonitorStackTraceElement[] fromStackTraceElements(StackTraceElement[] stackTraceElements) {
        return MonitorStackTraceElement.fromStackTraceElements(stackTraceElements, null);
    }

    public static MonitorStackTraceElement[] fromStackTraceElements(StackTraceElement[] stackTraceElements, Frame[] cachedFrames) {
        MonitorStackTraceElement[] monitorStackTraceElements = new MonitorStackTraceElement[stackTraceElements.length];
        int i = 0;
        int j = 0;
        while (i < stackTraceElements.length) {
            StackTraceElement stackTraceElement = stackTraceElements[i];
            Map<String, Object> locals = null;
            if (cachedFrames != null) {
                while (j < cachedFrames.length && !cachedFrames[j].getMethod().getName().equals(stackTraceElement.getMethodName())) {
                    ++j;
                }
                if (j < cachedFrames.length) {
                    locals = cachedFrames[j].getLocals();
                }
            }
            monitorStackTraceElements[i] = MonitorStackTraceElement.fromStackTraceElement(stackTraceElement, locals);
            ++i;
            ++j;
        }
        return monitorStackTraceElements;
    }

    public static MonitorStackTraceElement fromStackTraceElement(StackTraceElement stackTraceElement) {
        return MonitorStackTraceElement.fromStackTraceElement(stackTraceElement, null);
    }

    private static MonitorStackTraceElement fromStackTraceElement(StackTraceElement stackTraceElement, Map<String, Object> locals) {
        return new MonitorStackTraceElement(stackTraceElement.getClassName(), stackTraceElement.getMethodName(), stackTraceElement.getFileName(), stackTraceElement.getLineNumber(), null, null, null, locals);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MonitorStackTraceElement that = (MonitorStackTraceElement)o;
        if (this.lineno != that.lineno) {
            return false;
        }
        if (this.module != null ? !this.module.equals(that.module) : that.module != null) {
            return false;
        }
        if (this.function != null ? !this.function.equals(that.function) : that.function != null) {
            return false;
        }
        if (this.fileName != null ? !this.fileName.equals(that.fileName) : that.fileName != null) {
            return false;
        }
        if (this.colno != null ? !this.colno.equals(that.colno) : that.colno != null) {
            return false;
        }
        if (this.absPath != null ? !this.absPath.equals(that.absPath) : that.absPath != null) {
            return false;
        }
        if (this.platform != null ? !this.platform.equals(that.platform) : that.platform != null) {
            return false;
        }
        return this.locals != null ? this.locals.equals(that.locals) : that.locals == null;
    }

    public int hashCode() {
        int result = this.module != null ? this.module.hashCode() : 0;
        result = 31 * result + (this.function != null ? this.function.hashCode() : 0);
        result = 31 * result + (this.fileName != null ? this.fileName.hashCode() : 0);
        result = 31 * result + this.lineno;
        result = 31 * result + (this.colno != null ? this.colno.hashCode() : 0);
        result = 31 * result + (this.absPath != null ? this.absPath.hashCode() : 0);
        result = 31 * result + (this.platform != null ? this.platform.hashCode() : 0);
        result = 31 * result + (this.locals != null ? this.locals.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "MonitorStackTraceElement{module='" + this.module + '\'' + ", function='" + this.function + '\'' + ", fileName='" + this.fileName + '\'' + ", lineno=" + this.lineno + ", colno=" + this.colno + ", absPath='" + this.absPath + '\'' + ", platform='" + this.platform + '\'' + ", locals='" + this.locals + '\'' + '}';
    }
}

