/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.monitor.event;

import com.growingio.android.sdk.monitor.event.Breadcrumb;
import com.growingio.android.sdk.monitor.event.MonitorSdk;
import com.growingio.android.sdk.monitor.event.interfaces.MonitorInterface;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class Event
implements Serializable {
    private final UUID id;
    private String alias;
    private String message;
    private Date timestamp;
    private Level level;
    private String platform;
    private MonitorSdk sdk;
    private Map<String, String> tags = new HashMap<String, String>();
    private List<Breadcrumb> breadcrumbs = new ArrayList<Breadcrumb>();
    private Map<String, Map<String, Object>> contexts = new HashMap<String, Map<String, Object>>();
    private String release;
    private String dist;
    private String environment;
    private transient Map<String, Object> extra = new HashMap<String, Object>();
    private Map<String, MonitorInterface> monitorInterfaces = new HashMap<String, MonitorInterface>();

    Event(UUID id) {
        if (id == null) {
            throw new IllegalArgumentException("The id can't be null");
        }
        this.id = id;
    }

    public UUID getId() {
        return this.id;
    }

    public String getAlias() {
        return this.alias;
    }

    void setAlias(String alias) {
        this.alias = alias;
    }

    public String getMessage() {
        return this.message;
    }

    void setMessage(String message) {
        this.message = message;
    }

    public Date getTimestamp() {
        return this.timestamp != null ? (Date)this.timestamp.clone() : null;
    }

    void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public Level getLevel() {
        return this.level;
    }

    void setLevel(Level level) {
        this.level = level;
    }

    public String getPlatform() {
        return this.platform;
    }

    void setPlatform(String platform) {
        this.platform = platform;
    }

    public MonitorSdk getSdk() {
        return this.sdk;
    }

    public void setSdk(MonitorSdk sdk) {
        this.sdk = sdk;
    }

    public List<Breadcrumb> getBreadcrumbs() {
        return this.breadcrumbs;
    }

    void setBreadcrumbs(List<Breadcrumb> breadcrumbs) {
        this.breadcrumbs = breadcrumbs;
    }

    public Map<String, Map<String, Object>> getContexts() {
        return this.contexts;
    }

    public void setContexts(Map<String, Map<String, Object>> contexts) {
        this.contexts = contexts;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public String getRelease() {
        return this.release;
    }

    void setRelease(String release) {
        this.release = release;
    }

    public String getDist() {
        return this.dist;
    }

    public void setDist(String dist) {
        this.dist = dist;
    }

    public String getEnvironment() {
        return this.environment;
    }

    void setEnvironment(String environment) {
        this.environment = environment;
    }

    public Map<String, Object> getExtra() {
        if (this.extra == null) {
            this.extra = new HashMap<String, Object>();
        }
        return this.extra;
    }

    void setExtra(Map<String, Object> extra) {
        this.extra = extra;
    }

    public Map<String, MonitorInterface> getMonitorInterfaces() {
        return this.monitorInterfaces;
    }

    void setMonitorInterfaces(Map<String, MonitorInterface> monitorInterfaces) {
        this.monitorInterfaces = monitorInterfaces;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.extra = (Map)stream.readObject();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeObject(Event.convertToSerializable(this.extra));
    }

    private static HashMap<String, ? super Serializable> convertToSerializable(Map<String, Object> objectMap) {
        HashMap<String, Object> serializableMap = new HashMap<String, Object>(objectMap.size());
        for (Map.Entry<String, Object> objectEntry : objectMap.entrySet()) {
            if (objectEntry.getValue() == null) {
                serializableMap.put(objectEntry.getKey(), null);
                continue;
            }
            if (objectEntry.getValue() instanceof Serializable) {
                serializableMap.put(objectEntry.getKey(), (Serializable)objectEntry.getValue());
                continue;
            }
            serializableMap.put(objectEntry.getKey(), objectEntry.getValue().toString());
        }
        return serializableMap;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.id.equals(((Event)o).id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return "Event{level=" + (Object)((Object)this.level) + ", message='" + this.message + '\'' + '}';
    }

    public static enum Level {
        FATAL("fatal"),
        ERROR("error"),
        WARNING("warning"),
        INFO("info"),
        DEBUG("debug");

        private final String mName;

        private Level(String name) {
            this.mName = name;
        }

        public String toString() {
            return this.mName;
        }
    }
}

