/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.monitor.event;

import java.io.Serializable;
import java.util.Date;
import java.util.Map;

public class Breadcrumb
implements Serializable {
    private final Type type;
    private final Date timestamp;
    private final Level level;
    private final String message;
    private final String category;
    private final Map<String, String> data;

    Breadcrumb(Type type, Date timestamp, Level level, String message, String category, Map<String, String> data) {
        if (timestamp == null) {
            timestamp = new Date();
        }
        if (message == null && (data == null || data.size() < 1)) {
            throw new IllegalArgumentException("one of 'message' or 'data' must be set");
        }
        this.type = type;
        this.timestamp = timestamp;
        this.level = level;
        this.message = message;
        this.category = category;
        this.data = data;
    }

    public Type getType() {
        return this.type;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public Level getLevel() {
        return this.level;
    }

    public String getMessage() {
        return this.message;
    }

    public String getCategory() {
        return this.category;
    }

    public Map<String, String> getData() {
        return this.data;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Breadcrumb that = (Breadcrumb)o;
        if (this.type != that.type) {
            return false;
        }
        if (this.timestamp != null ? !this.timestamp.equals(that.timestamp) : that.timestamp != null) {
            return false;
        }
        if (this.level != that.level) {
            return false;
        }
        if (this.message != null ? !this.message.equals(that.message) : that.message != null) {
            return false;
        }
        if (this.category != null ? !this.category.equals(that.category) : that.category != null) {
            return false;
        }
        return this.data != null ? this.data.equals(that.data) : that.data == null;
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + (this.timestamp != null ? this.timestamp.hashCode() : 0);
        result = 31 * result + (this.level != null ? this.level.hashCode() : 0);
        result = 31 * result + (this.message != null ? this.message.hashCode() : 0);
        result = 31 * result + (this.category != null ? this.category.hashCode() : 0);
        result = 31 * result + (this.data != null ? this.data.hashCode() : 0);
        return result;
    }

    public static enum Type {
        DEFAULT("default"),
        HTTP("http"),
        NAVIGATION("navigation"),
        USER("user");

        private final String value;

        private Type(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum Level {
        DEBUG("debug"),
        INFO("info"),
        WARNING("warning"),
        ERROR("error"),
        CRITICAL("critical");

        private final String value;

        private Level(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

