/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.monitor.connection.cache;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import com.growingio.android.sdk.monitor.event.Event;
import com.growingio.android.sdk.monitor.log.MLog;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class MonitorDatabase
extends SQLiteOpenHelper {
    private static final String TAG = "MonitorDatabase";
    private static final String DATABASE_NAME = "GrowingioMonitor.db";
    private static final int DATABASE_VERSION = 2;
    private static final String TABLE_NAME = "monitor_event";
    private static final String KEY_EVENT_ID = "event_id";
    private static final String KEY_ALIAS = "alias";
    private static final String KEY_EVENT = "event";
    private static final String CREATE_TABLE = "CREATE TABLE IF NOT EXISTS monitor_event (_id INTEGER PRIMARY KEY AUTOINCREMENT, event_id TEXT NOT NULL, alias TEXT NOT NULL, event blob)";
    private static final String DROP_TABLE = "DROP TABLE IF EXISTS monitor_event";

    MonitorDatabase(Context context) {
        super(context, DATABASE_NAME, null, 2);
    }

    public void onCreate(SQLiteDatabase db) {
        db.execSQL(CREATE_TABLE);
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        if (oldVersion == 1) {
            try {
                db.execSQL(DROP_TABLE);
                this.onCreate(db);
            }
            catch (SQLException e) {
                MLog.e(TAG, "database upgrade failed", e);
            }
        }
    }

    void saveEvent(Event event) {
        try {
            String id = event.getId().toString();
            String alias = event.getAlias();
            SQLiteDatabase db = this.getReadableDatabase();
            byte[] bytes = this.event2Bytes(event);
            if (bytes == null) {
                return;
            }
            ContentValues cv = new ContentValues();
            cv.put(KEY_EVENT_ID, id);
            cv.put(KEY_ALIAS, alias);
            cv.put(KEY_EVENT, bytes);
            db.insert(TABLE_NAME, null, cv);
            MLog.d(TAG, "Save Event " + id + " successfully");
        }
        catch (Exception e) {
            MLog.e(TAG, e);
        }
    }

    void deleteEvent(Event event) {
        try {
            SQLiteDatabase db = this.getReadableDatabase();
            db.delete(TABLE_NAME, "event_id = ?", new String[]{event.getId().toString()});
        }
        catch (Exception e) {
            MLog.e(TAG, e);
        }
    }

    Event getLatelyEvent(String alias) {
        try {
            SQLiteDatabase db = this.getReadableDatabase();
            Cursor cursor = db.query(TABLE_NAME, null, "alias = ? ", new String[]{alias}, null, null, "_id desc", "1");
            Event event = null;
            if (cursor.moveToNext()) {
                byte[] bytes = cursor.getBlob(cursor.getColumnIndex(KEY_EVENT));
                event = this.bytes2Event(bytes);
            }
            cursor.close();
            return event;
        }
        catch (Exception e) {
            MLog.e(TAG, e);
            return null;
        }
    }

    private byte[] event2Bytes(Event event) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(event);
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception e) {
            MLog.e(TAG, e);
            return null;
        }
    }

    private Event bytes2Event(byte[] bytes) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            return (Event)objectInputStream.readObject();
        }
        catch (Exception e) {
            MLog.e(TAG, e);
            return null;
        }
    }
}

