/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.monitor.connection;

import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import com.growingio.android.sdk.monitor.Monitor;
import com.growingio.android.sdk.monitor.connection.Connection;
import com.growingio.android.sdk.monitor.connection.cache.DataHelper;
import com.growingio.android.sdk.monitor.dsn.Dsn;
import com.growingio.android.sdk.monitor.environment.MonitorEnvironment;
import com.growingio.android.sdk.monitor.event.Event;
import com.growingio.android.sdk.monitor.log.MLog;
import com.growingio.android.sdk.monitor.marshaller.json.JsonMarshaller;
import com.growingio.android.sdk.monitor.util.Util;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import org.json.JSONException;
import org.json.JSONObject;

public class HttpConnection
implements Connection {
    private static final String TAG = "HttpConnection";
    private static final String SENTRY_PROTOCOL_VERSION = "6";
    public static final int HTTP_TOO_MANY_REQUESTS = 429;
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final String USER_AGENT = "User-Agent";
    private static final String SENTRY_AUTH = "X-Sentry-Auth";
    private static String CONTENT_TYPE = "Content-Type";
    private static String DEFAULT_CONTENT_TYPE = "application/json";
    private static final int DEFAULT_CONNECT_TIMEOUT = 5000;
    private static final int DEFAULT_READ_TIMEOUT = 10000;
    private static final HostnameVerifier NAIVE_VERIFIER = new HostnameVerifier(){

        @Override
        public boolean verify(String hostname, SSLSession sslSession) {
            return true;
        }
    };
    private static final int SYNC_CACHE_EVENT = 1;
    private static final int MIN_AGE_MILLIS = 60000;
    private static final int MAX_SEND_EVENT_COUNT_DAILY = 20;
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();
    private final JsonMarshaller marshaller;
    private final String sentryApiUrl;
    private final String authHeader;
    private final String alias;
    private final WorkHandler workHandler;
    private final HandlerThread handlerThread;

    public HttpConnection(String alias, Dsn dsn, JsonMarshaller marshaller) {
        this.alias = alias;
        this.marshaller = marshaller;
        this.sentryApiUrl = dsn.getUri().toString() + "api/" + dsn.getProjectId() + "/store/";
        this.authHeader = "Sentry sentry_version=6,sentry_client=" + MonitorEnvironment.getMonitorName() + ",sentry_key=" + dsn.getPublicKey() + (!Util.isNullOrEmpty(dsn.getSecretKey()) ? ",sentry_secret=" + dsn.getSecretKey() : "");
        this.handlerThread = new HandlerThread("MonitorHandlerThread");
        this.handlerThread.start();
        this.workHandler = new WorkHandler(this.handlerThread.getLooper());
        Message.obtain((Handler)this.workHandler, (int)1).sendToTarget();
    }

    protected HttpURLConnection getConnection() {
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(this.sentryApiUrl).openConnection();
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(10000);
            connection.setRequestProperty(USER_AGENT, MonitorEnvironment.getMonitorName());
            connection.setRequestProperty(SENTRY_AUTH, this.authHeader);
            connection.setRequestProperty(CONTENT_TYPE, DEFAULT_CONTENT_TYPE);
            return connection;
        }
        catch (IOException e) {
            throw new IllegalStateException("Couldn't set up a connection to the Sentry server.", e);
        }
    }

    private void doSend(final Event event) {
        JSONObject eventJson;
        if (!this.isWifiConnect() && DataHelper.getSendEventsCountDaily() >= 20) {
            MLog.e(TAG, "Today send too many events to monitor server using 4G");
            return;
        }
        try {
            eventJson = this.marshaller.marshall(event);
        }
        catch (JSONException e) {
            MLog.e(TAG, e);
            return;
        }
        this.executorService.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                HttpURLConnection connection = HttpConnection.this.getConnection();
                if (connection instanceof HttpsURLConnection) {
                    ((HttpsURLConnection)connection).setHostnameVerifier(NAIVE_VERIFIER);
                }
                try {
                    OutputStream outputStream = connection.getOutputStream();
                    if (eventJson != null) {
                        outputStream.write(eventJson.toString().getBytes());
                    }
                    outputStream.flush();
                    outputStream.close();
                    connection.getInputStream().close();
                    DataHelper.deleteEvent(event);
                    if (!HttpConnection.this.isWifiConnect()) {
                        DataHelper.addOneSendEventCount();
                    }
                }
                catch (IOException e) {
                    Integer responseCode;
                    Long retryAfterMs;
                    block19: {
                        retryAfterMs = null;
                        String retryAfterHeader = connection.getHeaderField("Retry-After");
                        if (retryAfterHeader != null) {
                            try {
                                retryAfterMs = (long)(Double.parseDouble(retryAfterHeader) * 1000.0);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        responseCode = null;
                        responseCode = connection.getResponseCode();
                        if (responseCode != 403) break block19;
                        MLog.d(HttpConnection.TAG, "Event '" + event.getId() + "' was rejected by the Sentry server due to a filter, Retry-After: " + retryAfterMs + ", ResponseCode: " + responseCode);
                        return;
                    }
                    try {
                        if (responseCode == 429) {
                            MLog.d(HttpConnection.TAG, "Too many requests to Sentry: https://docs.sentry.io/learn/quotas/", e);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    String errorMessage = null;
                    InputStream errorStream = connection.getErrorStream();
                    if (errorStream != null) {
                        errorMessage = HttpConnection.this.getErrorMessageFromStream(errorStream);
                    }
                    if (null == errorMessage || errorMessage.isEmpty()) {
                        errorMessage = "An exception occurred while submitting the event to the Sentry server.";
                    }
                    MLog.d(HttpConnection.TAG, errorMessage + ", Retry-After: " + retryAfterMs + ", ResponseCode: " + responseCode, e);
                }
                finally {
                    connection.disconnect();
                }
            }
        });
    }

    private String getErrorMessageFromStream(InputStream errorStream) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(errorStream, UTF_8));
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            boolean first = true;
            while ((line = reader.readLine()) != null) {
                if (!first) {
                    sb.append("\n");
                }
                sb.append(line);
                first = false;
            }
        }
        catch (Exception e) {
            MLog.d(TAG, "Exception while reading the error message from the connection.", e);
        }
        return sb.toString();
    }

    @Override
    public void send(Event event) {
        MLog.d(TAG, "send event");
        DataHelper.saveEvent(event);
        this.doSend(event);
    }

    @Override
    public void stopSyncCachedEvent() {
        if (Build.VERSION.SDK_INT >= 18) {
            this.handlerThread.quitSafely();
        } else {
            this.handlerThread.quit();
        }
    }

    private boolean isWifiConnect() {
        ConnectivityManager connManager = (ConnectivityManager)Monitor.getAppContext().getSystemService("connectivity");
        NetworkInfo mWifiInfo = connManager.getNetworkInfo(1);
        return mWifiInfo.isConnected();
    }

    private class WorkHandler
    extends Handler {
        WorkHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            if (msg.what == 1) {
                Event event = DataHelper.getLatelyEvent(HttpConnection.this.alias);
                if (event == null) {
                    MLog.d(HttpConnection.TAG, "event is NULL, end SYNC_CACHE_EVENT, alias is " + HttpConnection.this.alias);
                } else {
                    HttpConnection.this.doSend(event);
                    this.sendEmptyMessageDelayed(1, 60000L);
                }
            }
        }
    }
}

