/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.monitor.analysis;

import android.text.TextUtils;
import com.growingio.android.sdk.monitor.analysis.StackGroup;
import java.util.ArrayList;
import java.util.List;

public class Analysed {
    public static final Analysed EMPTY_ANALYSED = new Analysed(null);
    private final Throwable mThrowable;
    private final List<StackGroup> mGroups = new ArrayList<StackGroup>();
    private boolean mFindTarget = false;
    private StackTraceElement mFirstTargetElement;

    public Analysed(Throwable throwable) {
        this.mThrowable = throwable;
    }

    public Throwable getThrowable() {
        return this.mThrowable;
    }

    public List<StackGroup> getGroups() {
        return this.mGroups;
    }

    public void setIsFindTarget(boolean findTarget) {
        this.mFindTarget = findTarget;
    }

    public boolean isFindTarget() {
        return this.mFindTarget;
    }

    public StackTraceElement getFirstTargetElement() {
        return this.mFirstTargetElement;
    }

    public void setFirstTargetElement(StackTraceElement firstTargetElement) {
        this.mFirstTargetElement = firstTargetElement;
    }

    public List<StackGroup> getGroups(String groupName) {
        ArrayList<StackGroup> result = new ArrayList<StackGroup>();
        if (TextUtils.isEmpty((CharSequence)groupName)) {
            return result;
        }
        for (StackGroup group : this.mGroups) {
            if (!groupName.equals(group.getName())) continue;
            result.add(group);
        }
        return result;
    }

    public StackGroup getGroup(int groupId) {
        if (groupId < 1 || groupId > this.mGroups.size()) {
            return StackGroup.NOT_FIND_GROUP;
        }
        for (StackGroup group : this.mGroups) {
            if (group.getId() != groupId) continue;
            return group;
        }
        return StackGroup.NOT_FIND_GROUP;
    }

    public List<StackTraceElement> getElements(int groupId) {
        if (groupId < 1 || groupId > this.mGroups.size()) {
            return new ArrayList<StackTraceElement>();
        }
        for (StackGroup group : this.mGroups) {
            if (group.getId() != groupId) continue;
            return group.getElements();
        }
        return new ArrayList<StackTraceElement>();
    }

    protected void addGroup(StackGroup group) {
        this.mGroups.add(group);
    }
}

