/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.monitor;

import com.growingio.android.sdk.monitor.Monitor;
import com.growingio.android.sdk.monitor.MonitorClient;
import com.growingio.android.sdk.monitor.analysis.Analysed;
import com.growingio.android.sdk.monitor.analysis.GIOAnalyser;
import com.growingio.android.sdk.monitor.event.Event;
import com.growingio.android.sdk.monitor.event.EventBuilder;
import com.growingio.android.sdk.monitor.event.interfaces.ExceptionInterface;
import com.growingio.android.sdk.monitor.log.MLog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.concurrent.ConcurrentLinkedQueue;

public class MonitorUncaughtExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static final String SDK_PACKAGE_NAME_PREFIX = "com.growingio.android";
    private static final String TAG = "MonitorUncaughtExceptionHandler";
    private static final int MAX_DEPTH = 10;
    private ConcurrentLinkedQueue<Class> ignoresExceptions = new ConcurrentLinkedQueue();
    private Thread.UncaughtExceptionHandler defaultExceptionHandler;
    private volatile Boolean enabled = true;

    private MonitorUncaughtExceptionHandler(Thread.UncaughtExceptionHandler defaultExceptionHandler) {
        this.defaultExceptionHandler = defaultExceptionHandler;
    }

    void addIgnoresException(Class clazz) {
        this.ignoresExceptions.add(clazz);
    }

    @Override
    public void uncaughtException(Thread thread, Throwable thrown) {
        block5: {
            if (this.enabled.booleanValue() && !this.isNeedIgnore(thrown)) {
                MLog.e(TAG, "Uncaught exception received.");
                EventBuilder eventBuilder = new EventBuilder().withMessage(thrown.getMessage()).withLevel(Event.Level.FATAL).withMonitorInterface(new ExceptionInterface(thrown));
                try {
                    Analysed analysed = GIOAnalyser.getInstance().getAnalyser().analyze(thrown);
                    if (!analysed.isFindTarget()) break block5;
                    MLog.e(TAG, "This could be Growing IO exception.");
                    ArrayList<MonitorClient> sortedMonitorClients = new ArrayList<MonitorClient>(Monitor.getAllStoredClients().values());
                    Collections.sort(sortedMonitorClients, new Comparator<MonitorClient>(){

                        @Override
                        public int compare(MonitorClient o1, MonitorClient o2) {
                            return o2.priority - o1.priority;
                        }
                    });
                    for (MonitorClient client : sortedMonitorClients) {
                        if (!client.filterThrowable(thrown)) continue;
                        client.sendEvent(eventBuilder);
                        break;
                    }
                }
                catch (Exception e) {
                    MLog.e(TAG, "Error sending uncaught exception to Monitor.", e);
                }
            }
        }
        if (this.defaultExceptionHandler != null) {
            this.defaultExceptionHandler.uncaughtException(thread, thrown);
        }
    }

    private boolean isNeedIgnore(Throwable thrown) {
        if (this.ignoresExceptions == null || this.ignoresExceptions.isEmpty()) {
            return false;
        }
        int deepth = 0;
        for (Class clazz : this.ignoresExceptions) {
            while (thrown != null && deepth++ < 10) {
                if (clazz.isInstance(thrown)) {
                    MLog.e(TAG, "ignored exception " + clazz.getSimpleName() + " received.");
                    return true;
                }
                thrown = thrown.getCause();
            }
        }
        return false;
    }

    public static MonitorUncaughtExceptionHandler setup() {
        Thread.UncaughtExceptionHandler currentHandler = Thread.getDefaultUncaughtExceptionHandler();
        MonitorUncaughtExceptionHandler handler = new MonitorUncaughtExceptionHandler(currentHandler);
        Thread.setDefaultUncaughtExceptionHandler(handler);
        return handler;
    }

    public void disable() {
        this.enabled = false;
        Thread.UncaughtExceptionHandler currentHandler = Thread.getDefaultUncaughtExceptionHandler();
        if (currentHandler == this) {
            Thread.setDefaultUncaughtExceptionHandler(this.defaultExceptionHandler);
        }
    }

    public Boolean isEnabled() {
        return this.enabled;
    }
}

