/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.monitor;

import android.support.annotation.NonNull;
import com.growingio.android.sdk.monitor.AndroidMonitorClientFactory;
import com.growingio.android.sdk.monitor.EmptyMonitorClient;
import com.growingio.android.sdk.monitor.MonitorClient;
import com.growingio.android.sdk.monitor.MonitorClientFactory;
import com.growingio.android.sdk.monitor.MonitorUncaughtExceptionHandler;
import com.growingio.android.sdk.monitor.connection.cache.DataHelper;
import com.growingio.android.sdk.monitor.context.Context;
import com.growingio.android.sdk.monitor.event.EventBuilder;
import com.growingio.android.sdk.monitor.log.MLog;
import com.growingio.android.sdk.monitor.util.Util;
import java.util.concurrent.ConcurrentHashMap;

public final class Monitor {
    private static final String TAG = "Monitor";
    private static ConcurrentHashMap<String, MonitorClient> storedClients = new ConcurrentHashMap();
    private static android.content.Context appContext;
    private static MonitorUncaughtExceptionHandler uncaughtExceptionHandler;
    private static volatile boolean mIsInit;
    private static volatile int priority;

    private Monitor() {
    }

    public static synchronized MonitorClient register(@NonNull String alias, @NonNull String dsn, @NonNull android.content.Context context, MonitorClient.FilterThrowableRule filterThrowableRule) {
        if (context == null || Util.isNullOrEmpty(alias) || Util.isNullOrEmpty(dsn)) {
            throw new IllegalArgumentException("alias, dsn and appContext can't be null");
        }
        Monitor.init(context);
        AndroidMonitorClientFactory monitorClientFactory = new AndroidMonitorClientFactory(context);
        MonitorClient monitorClient = MonitorClientFactory.monitorClient(alias, dsn, monitorClientFactory);
        monitorClient.setPriority(priority++);
        if (filterThrowableRule != null) {
            monitorClient.setFilterThrowable(filterThrowableRule);
        }
        Monitor.setStoredClient(alias, monitorClient);
        return monitorClient;
    }

    public static synchronized void unregister(@NonNull String alias) {
        if (!storedClients.containsKey(alias) || storedClients.get(alias) == null) {
            MLog.d(TAG, "alias " + alias + " not exist when call unregister");
            return;
        }
        storedClients.get(alias).stopSyncCachedEvent();
        storedClients.remove(alias);
    }

    public static void addIgnoresException(Class clazz) {
        if (uncaughtExceptionHandler == null) {
            MLog.d(TAG, "Please init monitor first!");
            return;
        }
        uncaughtExceptionHandler.addIgnoresException(clazz);
    }

    public static boolean isContainsClient(@NonNull String alias) {
        return storedClients.containsKey(alias);
    }

    public static MonitorClient getStoredClient(@NonNull String alias) {
        if (storedClients.containsKey(alias)) {
            return storedClients.get(alias);
        }
        MLog.e(TAG, "Please init monitor with alias " + alias + " first!");
        return EmptyMonitorClient.EMPTY_MONITOR_CLIENT;
    }

    public static ConcurrentHashMap<String, MonitorClient> getAllStoredClients() {
        if (storedClients != null) {
            return storedClients;
        }
        throw new IllegalArgumentException("Please init monitor first!");
    }

    public static android.content.Context getAppContext() {
        if (appContext != null) {
            return appContext;
        }
        throw new IllegalArgumentException("Please init monitor first!");
    }

    public static Context getContext(@NonNull String alias) {
        return Monitor.getStoredClient(alias).getContext();
    }

    public static void clearContext(@NonNull String alias) {
        Monitor.getStoredClient(alias).clearContext();
    }

    public static void capture(@NonNull String alias, @NonNull Throwable throwable) {
        Monitor.getStoredClient(alias).sendException(throwable);
    }

    public static void capture(@NonNull String alias, String message) {
        Monitor.getStoredClient(alias).sendMessage(message);
    }

    public static void capture(@NonNull String alias, @NonNull EventBuilder eventBuilder) {
        Monitor.getStoredClient(alias).sendEvent(eventBuilder);
    }

    public static void close(@NonNull String alias) {
        if (!storedClients.containsKey(alias)) {
            return;
        }
        Monitor.getStoredClient(alias).closeConnection();
    }

    private static void init(android.content.Context context) {
        if (mIsInit) {
            return;
        }
        appContext = context.getApplicationContext();
        DataHelper.init(appContext);
        if (uncaughtExceptionHandler == null) {
            Monitor.setupUncaughtExceptionHandler();
        }
    }

    private static void setupUncaughtExceptionHandler() {
        uncaughtExceptionHandler = MonitorUncaughtExceptionHandler.setup();
    }

    private static void setStoredClient(String alias, MonitorClient client) {
        if (storedClients.containsKey(alias)) {
            storedClients.get(alias).stopSyncCachedEvent();
            MLog.e(TAG, "Overwriting statically stored MonitorClient instance, alias is " + alias + ", unregister the previous client");
        }
        storedClients.put(alias, client);
    }

    static {
        mIsInit = false;
        priority = 0;
    }
}

