/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.monitor;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.util.Log;
import com.growingio.android.sdk.monitor.DefaultMonitorClientFactory;
import com.growingio.android.sdk.monitor.MonitorClient;
import com.growingio.android.sdk.monitor.context.ContextManager;
import com.growingio.android.sdk.monitor.context.SingletonContextManager;
import com.growingio.android.sdk.monitor.dsn.Dsn;
import com.growingio.android.sdk.monitor.event.helper.AndroidEventBuilderHelper;
import com.growingio.android.sdk.monitor.util.Util;
import java.util.ArrayList;
import java.util.Collection;

public class AndroidMonitorClientFactory
extends DefaultMonitorClientFactory {
    public static final String TAG = AndroidMonitorClientFactory.class.getName();
    private Context ctx;

    public AndroidMonitorClientFactory(Context ctx) {
        Log.d((String)TAG, (String)"Construction of Android Monitor.");
        this.ctx = ctx.getApplicationContext();
    }

    @Override
    public MonitorClient createMonitorClient(String alias, Dsn dsn) {
        if (!this.checkPermission("android.permission.INTERNET")) {
            Log.e((String)TAG, (String)"android.permission.INTERNET is required to connect to the Monitor server, please add it to your AndroidManifest.xml");
        }
        Log.d((String)TAG, (String)("Monitor init with ctx='" + this.ctx.toString()));
        MonitorClient monitorClient = super.createMonitorClient(alias, dsn);
        monitorClient.addBuilderHelper(new AndroidEventBuilderHelper(this.ctx, monitorClient.getContext()));
        return monitorClient;
    }

    @Override
    protected Collection<String> getInAppFrames(Dsn dsn) {
        Collection<String> inAppFrames = super.getInAppFrames(dsn);
        if (inAppFrames.isEmpty()) {
            PackageInfo info = null;
            try {
                info = this.ctx.getPackageManager().getPackageInfo(this.ctx.getPackageName(), 0);
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.e((String)TAG, (String)"Error getting package information.", (Throwable)e);
            }
            if (info != null && !Util.isNullOrEmpty(info.packageName)) {
                ArrayList<String> newPackages = new ArrayList<String>(1);
                newPackages.add(info.packageName);
                return newPackages;
            }
        }
        return inAppFrames;
    }

    @Override
    protected ContextManager getContextManager(Dsn dsn) {
        return new SingletonContextManager();
    }

    private boolean checkPermission(String permission2) {
        int res = this.ctx.checkCallingOrSelfPermission(permission2);
        return res == 0;
    }
}

