/*
 * Decompiled with CFR 0.152.
 */
package com.greedygame.network.toolbox;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.http.AndroidHttpClient;
import android.os.Build;
import com.greedygame.network.Network;
import com.greedygame.network.RequestQueue;
import com.greedygame.network.toolbox.BaseHttpStack;
import com.greedygame.network.toolbox.BasicNetwork;
import com.greedygame.network.toolbox.DiskBasedCache;
import com.greedygame.network.toolbox.HttpClientStack;
import com.greedygame.network.toolbox.HttpStack;
import com.greedygame.network.toolbox.HurlStack;
import java.io.File;
import org.apache.http.client.HttpClient;

public class Volley {
    private static final String DEFAULT_CACHE_DIR = "volley";

    public static RequestQueue newRequestQueue(Context context, BaseHttpStack stack) {
        BasicNetwork network;
        if (stack == null) {
            if (Build.VERSION.SDK_INT >= 9) {
                network = new BasicNetwork(new HurlStack());
            } else {
                String userAgent = "volley/0";
                try {
                    String packageName = context.getPackageName();
                    PackageInfo info = context.getPackageManager().getPackageInfo(packageName, 0);
                    userAgent = packageName + "/" + info.versionCode;
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    // empty catch block
                }
                network = new BasicNetwork(new HttpClientStack((HttpClient)AndroidHttpClient.newInstance((String)userAgent)));
            }
        } else {
            network = new BasicNetwork(stack);
        }
        return Volley.newRequestQueue(context, network);
    }

    @Deprecated
    public static RequestQueue newRequestQueue(Context context, HttpStack stack) {
        if (stack == null) {
            return Volley.newRequestQueue(context, (BaseHttpStack)null);
        }
        return Volley.newRequestQueue(context, new BasicNetwork(stack));
    }

    private static RequestQueue newRequestQueue(Context context, Network network) {
        File cacheDir = new File(context.getCacheDir(), DEFAULT_CACHE_DIR);
        RequestQueue queue = new RequestQueue(new DiskBasedCache(cacheDir), network);
        queue.start();
        return queue;
    }

    public static RequestQueue newRequestQueue(Context context) {
        return Volley.newRequestQueue(context, (BaseHttpStack)null);
    }
}

