/*
 * Decompiled with CFR 0.152.
 */
package com.greedygame.network;

import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import androidx.annotation.CallSuper;
import androidx.annotation.GuardedBy;
import androidx.annotation.Nullable;
import com.greedygame.network.AuthFailureError;
import com.greedygame.network.Cache;
import com.greedygame.network.DefaultRetryPolicy;
import com.greedygame.network.NetworkResponse;
import com.greedygame.network.RequestQueue;
import com.greedygame.network.Response;
import com.greedygame.network.RetryPolicy;
import com.greedygame.network.VolleyError;
import com.greedygame.network.VolleyLog;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;

public abstract class Request<T>
implements Comparable<Request<T>> {
    private static final String DEFAULT_PARAMS_ENCODING = "UTF-8";
    private final VolleyLog.MarkerLog mEventLog = VolleyLog.MarkerLog.ENABLED ? new VolleyLog.MarkerLog() : null;
    private final int mMethod;
    private final String mUrl;
    private final int mDefaultTrafficStatsTag;
    private final Object mLock = new Object();
    @Nullable
    @GuardedBy(value="mLock")
    private Response.ErrorListener mErrorListener;
    private Integer mSequence;
    private RequestQueue mRequestQueue;
    private boolean mShouldCache = true;
    @GuardedBy(value="mLock")
    private boolean mCanceled = false;
    @GuardedBy(value="mLock")
    private boolean mResponseDelivered = false;
    private boolean mShouldRetryServerErrors = false;
    private RetryPolicy mRetryPolicy;
    private Cache.Entry mCacheEntry = null;
    private Object mTag;
    @GuardedBy(value="mLock")
    private NetworkRequestCompleteListener mRequestCompleteListener;

    @Deprecated
    public Request(String url, Response.ErrorListener listener) {
        this(-1, url, listener);
    }

    public Request(int method, String url, @Nullable Response.ErrorListener listener) {
        this.mMethod = method;
        this.mUrl = url;
        this.mErrorListener = listener;
        this.setRetryPolicy(new DefaultRetryPolicy());
        this.mDefaultTrafficStatsTag = Request.findDefaultTrafficStatsTag(url);
    }

    public int getMethod() {
        return this.mMethod;
    }

    public Request<?> setTag(Object tag) {
        this.mTag = tag;
        return this;
    }

    public Object getTag() {
        return this.mTag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Response.ErrorListener getErrorListener() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mErrorListener;
        }
    }

    public int getTrafficStatsTag() {
        return this.mDefaultTrafficStatsTag;
    }

    private static int findDefaultTrafficStatsTag(String url) {
        String host;
        Uri uri;
        if (!TextUtils.isEmpty((CharSequence)url) && (uri = Uri.parse((String)url)) != null && (host = uri.getHost()) != null) {
            return host.hashCode();
        }
        return 0;
    }

    public Request<?> setRetryPolicy(RetryPolicy retryPolicy) {
        this.mRetryPolicy = retryPolicy;
        return this;
    }

    public void addMarker(String tag) {
        if (VolleyLog.MarkerLog.ENABLED) {
            this.mEventLog.add(tag, Thread.currentThread().getId());
        }
    }

    void finish(final String tag) {
        if (this.mRequestQueue != null) {
            this.mRequestQueue.finish(this);
        }
        if (VolleyLog.MarkerLog.ENABLED) {
            final long threadId = Thread.currentThread().getId();
            if (Looper.myLooper() != Looper.getMainLooper()) {
                Handler mainThread = new Handler(Looper.getMainLooper());
                mainThread.post(new Runnable(){

                    @Override
                    public void run() {
                        Request.this.mEventLog.add(tag, threadId);
                        Request.this.mEventLog.finish(Request.this.toString());
                    }
                });
                return;
            }
            this.mEventLog.add(tag, threadId);
            this.mEventLog.finish(this.toString());
        }
    }

    public Request<?> setRequestQueue(RequestQueue requestQueue) {
        this.mRequestQueue = requestQueue;
        return this;
    }

    public final Request<?> setSequence(int sequence) {
        this.mSequence = sequence;
        return this;
    }

    public final int getSequence() {
        if (this.mSequence == null) {
            throw new IllegalStateException("getSequence called before setSequence");
        }
        return this.mSequence;
    }

    public String getUrl() {
        return this.mUrl;
    }

    public String getCacheKey() {
        String url = this.getUrl();
        int method = this.getMethod();
        if (method == 0 || method == -1) {
            return url;
        }
        return Integer.toString(method) + '-' + url;
    }

    public Request<?> setCacheEntry(Cache.Entry entry) {
        this.mCacheEntry = entry;
        return this;
    }

    public Cache.Entry getCacheEntry() {
        return this.mCacheEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CallSuper
    public void cancel() {
        Object object = this.mLock;
        synchronized (object) {
            this.mCanceled = true;
            this.mErrorListener = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCanceled() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mCanceled;
        }
    }

    public Map<String, String> getHeaders() throws AuthFailureError {
        return new HashMap<String, String>();
    }

    @Deprecated
    protected Map<String, String> getPostParams() throws AuthFailureError {
        return this.getParams();
    }

    @Deprecated
    protected String getPostParamsEncoding() {
        return this.getParamsEncoding();
    }

    @Deprecated
    public String getPostBodyContentType() {
        return this.getBodyContentType();
    }

    @Deprecated
    public byte[] getPostBody() throws AuthFailureError {
        Map<String, String> postParams = this.getPostParams();
        if (postParams != null && postParams.size() > 0) {
            return this.encodeParameters(postParams, this.getPostParamsEncoding());
        }
        return null;
    }

    protected Map<String, String> getParams() throws AuthFailureError {
        return null;
    }

    protected String getParamsEncoding() {
        return DEFAULT_PARAMS_ENCODING;
    }

    public String getBodyContentType() {
        return "application/x-www-form-urlencoded; charset=" + this.getParamsEncoding();
    }

    public byte[] getBody() throws AuthFailureError {
        Map<String, String> params = this.getParams();
        if (params != null && params.size() > 0) {
            return this.encodeParameters(params, this.getParamsEncoding());
        }
        return null;
    }

    private byte[] encodeParameters(Map<String, String> params, String paramsEncoding) {
        StringBuilder encodedParams = new StringBuilder();
        try {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                if (entry.getKey() == null || entry.getValue() == null) {
                    throw new IllegalArgumentException(String.format("Request#getParams() or Request#getPostParams() returned a map containing a null key or value: (%s, %s). All keys and values must be non-null.", entry.getKey(), entry.getValue()));
                }
                encodedParams.append(URLEncoder.encode(entry.getKey(), paramsEncoding));
                encodedParams.append('=');
                encodedParams.append(URLEncoder.encode(entry.getValue(), paramsEncoding));
                encodedParams.append('&');
            }
            return encodedParams.toString().getBytes(paramsEncoding);
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("Encoding not supported: " + paramsEncoding, uee);
        }
    }

    public final Request<?> setShouldCache(boolean shouldCache) {
        this.mShouldCache = shouldCache;
        return this;
    }

    public final boolean shouldCache() {
        return this.mShouldCache;
    }

    public final Request<?> setShouldRetryServerErrors(boolean shouldRetryServerErrors) {
        this.mShouldRetryServerErrors = shouldRetryServerErrors;
        return this;
    }

    public final boolean shouldRetryServerErrors() {
        return this.mShouldRetryServerErrors;
    }

    public Priority getPriority() {
        return Priority.NORMAL;
    }

    public final int getTimeoutMs() {
        return this.getRetryPolicy().getCurrentTimeout();
    }

    public RetryPolicy getRetryPolicy() {
        return this.mRetryPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markDelivered() {
        Object object = this.mLock;
        synchronized (object) {
            this.mResponseDelivered = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasHadResponseDelivered() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mResponseDelivered;
        }
    }

    protected abstract Response<T> parseNetworkResponse(NetworkResponse var1);

    protected VolleyError parseNetworkError(VolleyError volleyError) {
        return volleyError;
    }

    protected abstract void deliverResponse(T var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deliverError(VolleyError error) {
        Response.ErrorListener listener;
        Object object = this.mLock;
        synchronized (object) {
            listener = this.mErrorListener;
        }
        if (listener != null) {
            listener.onErrorResponse(error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setNetworkRequestCompleteListener(NetworkRequestCompleteListener requestCompleteListener) {
        Object object = this.mLock;
        synchronized (object) {
            this.mRequestCompleteListener = requestCompleteListener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyListenerResponseReceived(Response<?> response) {
        NetworkRequestCompleteListener listener;
        Object object = this.mLock;
        synchronized (object) {
            listener = this.mRequestCompleteListener;
        }
        if (listener != null) {
            listener.onResponseReceived(this, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyListenerResponseNotUsable() {
        NetworkRequestCompleteListener listener;
        Object object = this.mLock;
        synchronized (object) {
            listener = this.mRequestCompleteListener;
        }
        if (listener != null) {
            listener.onNoUsableResponseReceived(this);
        }
    }

    @Override
    public int compareTo(Request<T> other) {
        Priority right;
        Priority left = this.getPriority();
        return left == (right = other.getPriority()) ? this.mSequence - other.mSequence : right.ordinal() - left.ordinal();
    }

    public String toString() {
        String trafficStatsTag = "0x" + Integer.toHexString(this.getTrafficStatsTag());
        return (this.isCanceled() ? "[X] " : "[ ] ") + this.getUrl() + " " + trafficStatsTag + " " + (Object)((Object)this.getPriority()) + " " + this.mSequence;
    }

    public static enum Priority {
        LOW,
        NORMAL,
        HIGH,
        IMMEDIATE;

    }

    static interface NetworkRequestCompleteListener {
        public void onResponseReceived(Request<?> var1, Response<?> var2);

        public void onNoUsableResponseReceived(Request<?> var1);
    }

    public static interface Method {
        public static final int DEPRECATED_GET_OR_POST = -1;
        public static final int GET = 0;
        public static final int POST = 1;
        public static final int PUT = 2;
        public static final int DELETE = 3;
        public static final int HEAD = 4;
        public static final int OPTIONS = 5;
        public static final int TRACE = 6;
        public static final int PATCH = 7;
    }
}

