/*
 * Decompiled with CFR 0.152.
 */
package com.greedygame.network;

import androidx.annotation.NonNull;
import com.greedygame.network.Header;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class NetworkResponse {
    public final int statusCode;
    public final byte[] data;
    public final Map<String, String> headers;
    public final List<Header> allHeaders;
    public final boolean notModified;
    public final long networkTimeMs;

    @Deprecated
    public NetworkResponse(int statusCode, byte[] data, Map<String, String> headers, boolean notModified, long networkTimeMs) {
        this(statusCode, data, headers, NetworkResponse.toAllHeaderList(headers), notModified, networkTimeMs);
    }

    public NetworkResponse(int statusCode, byte[] data, boolean notModified, long networkTimeMs, List<Header> allHeaders) {
        this(statusCode, data, NetworkResponse.toHeaderMap(allHeaders), allHeaders, notModified, networkTimeMs);
    }

    @Deprecated
    public NetworkResponse(int statusCode, byte[] data, Map<String, String> headers, boolean notModified) {
        this(statusCode, data, headers, notModified, 0L);
    }

    public NetworkResponse(byte[] data) {
        this(200, data, false, 0L, Collections.emptyList());
    }

    @Deprecated
    public NetworkResponse(byte[] data, Map<String, String> headers) {
        this(200, data, headers, false, 0L);
    }

    private NetworkResponse(int statusCode, byte[] data, Map<String, String> headers, List<Header> allHeaders, boolean notModified, long networkTimeMs) {
        this.statusCode = statusCode;
        this.data = data;
        this.headers = headers;
        this.allHeaders = allHeaders == null ? null : Collections.unmodifiableList(allHeaders);
        this.notModified = notModified;
        this.networkTimeMs = networkTimeMs;
    }

    private static Map<String, String> toHeaderMap(List<Header> allHeaders) {
        if (allHeaders == null) {
            return null;
        }
        if (allHeaders.isEmpty()) {
            return Collections.emptyMap();
        }
        TreeMap<String, String> headers = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        for (Header header : allHeaders) {
            headers.put(header.getName(), header.getValue());
        }
        return headers;
    }

    private static List<Header> toAllHeaderList(Map<String, String> headers) {
        if (headers == null) {
            return null;
        }
        if (headers.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Header> allHeaders = new ArrayList<Header>(headers.size());
        for (Map.Entry<String, String> header : headers.entrySet()) {
            allHeaders.add(new Header(header.getKey(), header.getValue()));
        }
        return allHeaders;
    }

    @NonNull
    public String toString() {
        return "Status:" + this.statusCode + "\n" + this.headers.toString() + new String(this.data);
    }
}

