/*
 * Decompiled with CFR 0.152.
 */
package com.graphql.spring.boot.test;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.graphql.spring.boot.test.JacksonFriendlySourceLocation;
import graphql.ErrorClassification;
import graphql.ErrorType;
import graphql.GraphQLError;
import graphql.language.SourceLocation;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.util.NumberUtils;

public class GraphQLTestError
implements GraphQLError {
    private String message;
    @JsonTypeInfo(defaultImpl=JacksonFriendlySourceLocation.class, use=JsonTypeInfo.Id.NAME)
    private List<SourceLocation> locations;
    @JsonTypeInfo(defaultImpl=ErrorType.class, use=JsonTypeInfo.Id.NAME)
    private transient ErrorClassification errorType;
    private transient List<Object> path;
    private transient Map<String, Object> extensions;

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Optional.ofNullable(this.errorType).map(Object::toString).orElse("<Unspecified error>"));
        sb.append(": ");
        sb.append(Optional.ofNullable(this.message).orElse("<error message not provided>"));
        if (Objects.nonNull(this.locations) && !this.locations.isEmpty()) {
            sb.append(" at line ");
            this.locations.forEach(location -> sb.append(location.getLine()).append(", column ").append(location.getColumn()).append(" in ").append(Optional.ofNullable(location.getSourceName()).orElse("unnamed/unspecified source")));
        }
        if (Objects.nonNull(this.path) && !this.path.isEmpty()) {
            sb.append(". Selection path: ");
            sb.append(this.path.stream().map(Object::toString).map(this::toNumericIndexIfPossible).collect(Collectors.joining("/")).replace("/[", "["));
        }
        return sb.toString();
    }

    private String toNumericIndexIfPossible(String s) {
        try {
            return "[" + NumberUtils.parseNumber((String)s, Long.class) + "]";
        }
        catch (IllegalArgumentException e) {
            return s;
        }
    }

    @Generated
    public static GraphQLTestErrorBuilder builder() {
        return new GraphQLTestErrorBuilder();
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public List<SourceLocation> getLocations() {
        return this.locations;
    }

    @Generated
    public ErrorClassification getErrorType() {
        return this.errorType;
    }

    @Generated
    public List<Object> getPath() {
        return this.path;
    }

    @Generated
    public Map<String, Object> getExtensions() {
        return this.extensions;
    }

    @Generated
    public void setMessage(String message) {
        this.message = message;
    }

    @JsonTypeInfo(defaultImpl=JacksonFriendlySourceLocation.class, use=JsonTypeInfo.Id.NAME)
    @Generated
    public void setLocations(List<SourceLocation> locations) {
        this.locations = locations;
    }

    @JsonTypeInfo(defaultImpl=ErrorType.class, use=JsonTypeInfo.Id.NAME)
    @Generated
    public void setErrorType(ErrorClassification errorType) {
        this.errorType = errorType;
    }

    @Generated
    public void setPath(List<Object> path) {
        this.path = path;
    }

    @Generated
    public void setExtensions(Map<String, Object> extensions) {
        this.extensions = extensions;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GraphQLTestError)) {
            return false;
        }
        GraphQLTestError other = (GraphQLTestError)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        List<SourceLocation> this$locations = this.getLocations();
        List<SourceLocation> other$locations = other.getLocations();
        return !(this$locations == null ? other$locations != null : !((Object)this$locations).equals(other$locations));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GraphQLTestError;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        List<SourceLocation> $locations = this.getLocations();
        result = result * 59 + ($locations == null ? 43 : ((Object)$locations).hashCode());
        return result;
    }

    @Generated
    public GraphQLTestError() {
    }

    @Generated
    public GraphQLTestError(String message, List<SourceLocation> locations, ErrorClassification errorType, List<Object> path, Map<String, Object> extensions) {
        this.message = message;
        this.locations = locations;
        this.errorType = errorType;
        this.path = path;
        this.extensions = extensions;
    }

    @Generated
    public static class GraphQLTestErrorBuilder {
        @Generated
        private String message;
        @Generated
        private List<SourceLocation> locations;
        @Generated
        private ErrorClassification errorType;
        @Generated
        private List<Object> path;
        @Generated
        private Map<String, Object> extensions;

        @Generated
        GraphQLTestErrorBuilder() {
        }

        @Generated
        public GraphQLTestErrorBuilder message(String message) {
            this.message = message;
            return this;
        }

        @JsonTypeInfo(defaultImpl=JacksonFriendlySourceLocation.class, use=JsonTypeInfo.Id.NAME)
        @Generated
        public GraphQLTestErrorBuilder locations(List<SourceLocation> locations) {
            this.locations = locations;
            return this;
        }

        @JsonTypeInfo(defaultImpl=ErrorType.class, use=JsonTypeInfo.Id.NAME)
        @Generated
        public GraphQLTestErrorBuilder errorType(ErrorClassification errorType) {
            this.errorType = errorType;
            return this;
        }

        @Generated
        public GraphQLTestErrorBuilder path(List<Object> path) {
            this.path = path;
            return this;
        }

        @Generated
        public GraphQLTestErrorBuilder extensions(Map<String, Object> extensions) {
            this.extensions = extensions;
            return this;
        }

        @Generated
        public GraphQLTestError build() {
            return new GraphQLTestError(this.message, this.locations, this.errorType, this.path, this.extensions);
        }

        @Generated
        public String toString() {
            return "GraphQLTestError.GraphQLTestErrorBuilder(message=" + this.message + ", locations=" + this.locations + ", errorType=" + this.errorType + ", path=" + this.path + ", extensions=" + this.extensions + ")";
        }
    }
}

