package com.gradle.publish;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public class PluginBundleExtension {

    private String website;
    private String description;
    private String vcsUrl;
    private Collection<String> bundleTags;
    private Map<String, Collection<String>> pluginTags;

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("PluginBundleExtension{");
        if (website != null && !website.isEmpty()) {
            sb.append(", website='").append(website).append('\'');
        }
        if (vcsUrl != null && !vcsUrl.isEmpty()) {
            sb.append(", vcsUrl='").append(vcsUrl).append('\'');
        }
        if (description != null && !description.isEmpty()) {
            sb.append(", description='").append(description).append('\'');
        }
        if (bundleTags != null && !bundleTags.isEmpty()) {
            sb.append(", tags='").append(bundleTags).append('\'');
        }
        if (pluginTags != null && !pluginTags.isEmpty()) {
            sb.append(", pluginTags='").append(pluginTags).append('\'');
        }
        sb.append('}');
        return sb.toString();
    }

    public boolean isEmpty() {
        if (website != null && !website.isEmpty()) {
            return false;
        }
        if (vcsUrl != null && !vcsUrl.isEmpty()) {
            return false;
        }
        if (description != null && !description.isEmpty()) {
            return false;
        }
        if (bundleTags != null && !bundleTags.isEmpty()) {
            return false;
        }
        if (pluginTags != null && !pluginTags.isEmpty()) {
            return false;
        }
        return true;
    }

    public String getWebsite() {
        return website;
    }

    public void setWebsite(String website) {
        this.website = website;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getVcsUrl() {
        return vcsUrl;
    }

    public void setVcsUrl(String vcsUrl) {
        this.vcsUrl = vcsUrl;
    }

    /**
     * Returns the tags for declared plugins. These tags apply to all plugins contained by the bundle, unless
     * specific tags for individual plugins are declared (@see #pluginTags), in which case those take precedence.
     */
    public Collection<String> getTags() {
        if (bundleTags == null) {
            return Collections.emptySet();
        }
        return bundleTags;
    }

    /**
     * Specify the tags to be used for all plugins contained by the bundle. If individual tags for specific plugins are
     * also declared, those take precedence over the bundle level tags.
     */
    public void setTags(Collection<String> tags) {
        this.bundleTags = tags;
    }

    /**
     * Returns the individual tags for declared plugins. If specified, individual plugin tags take precedence
     * over bundle level tags.
     */
    public Map<String, Collection<String>> getPluginTags() {
        if (pluginTags == null) {
            return Collections.emptyMap();
        }
        return pluginTags;
    }

    /**
     * Set individual tags for the declared plugins. If specified, individual plugin tags take precedence
     * over bundle level tags (on a per-plugin basis).
     */
    public void setPluginTags(Map<String, Collection<String>> pluginTags) {
        this.pluginTags = pluginTags;
    }
}
