/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.publish;

import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.component.AdhocComponentWithVariants;
import org.gradle.api.component.ConfigurationVariantDetails;
import org.gradle.api.component.SoftwareComponent;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.AppliedPlugin;
import org.gradle.jvm.tasks.Jar;

public class PublishTaskShadowAction
implements Action<AppliedPlugin> {
    private final Project project;
    private final Logger logger;

    public PublishTaskShadowAction(Project project, Logger logger) {
        this.project = project;
        this.logger = logger;
    }

    public void execute(AppliedPlugin appliedPlugin) {
        this.logger.lifecycle("Shadow plugin detected. Will automatically select a fat jar as the main plugin artifact.");
        ConfigurationContainer configurations = this.project.getConfigurations();
        this.manipulateVariants(configurations);
        this.manipulateDependencies(configurations);
    }

    private void manipulateVariants(ConfigurationContainer configurations) {
        if (configurations.getByName("shadowRuntimeElements").getAllArtifacts().stream().anyMatch(a -> a.getClassifier() != null && !a.getClassifier().isEmpty())) {
            throw new RuntimeException("Please configure the `shadowJar` task to not add a classifier to the jar it produces");
        }
        this.project.getTasks().named("jar", Jar.class, jar -> jar.getArchiveClassifier().set((Object)"main"));
        SoftwareComponent javaComponent = (SoftwareComponent)this.project.getComponents().getByName("java");
        AdhocComponentWithVariants adhocComponent = (AdhocComponentWithVariants)javaComponent;
        adhocComponent.addVariantsFromConfiguration(configurations.getByName("apiElements"), ConfigurationVariantDetails::skip);
        adhocComponent.addVariantsFromConfiguration(configurations.getByName("runtimeElements"), ConfigurationVariantDetails::skip);
        adhocComponent.addVariantsFromConfiguration(configurations.getByName("shadowRuntimeElements"), configVariantDetails -> configVariantDetails.mapToMavenScope("runtime"));
    }

    private void manipulateDependencies(ConfigurationContainer configurations) {
        Configuration compileOnly;
        Dependency gradleApi = this.project.getDependencies().gradleApi();
        Configuration api = (Configuration)configurations.findByName("api");
        if (api != null) {
            api.getDependencies().remove((Object)gradleApi);
        }
        if ((compileOnly = (Configuration)configurations.findByName("compileOnly")) != null) {
            compileOnly.getDependencies().add((Object)gradleApi);
        }
    }
}

