/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.publish;

import com.gradle.protocols.ServerResponseBase;
import com.gradle.publish.Config;
import com.gradle.publish.OAuthHttpClient;
import com.gradle.publish.PropertiesStore;
import com.gradle.publish.PublishTask;
import com.gradle.publish.ResponseUtil;
import com.gradle.publish.protocols.v1.models.ClientPostRequest;
import com.gradle.publish.protocols.v1.models.publish.PublishActivateRequest;
import com.gradle.publish.protocols.v1.models.publish.PublishArtifact;
import com.gradle.publish.protocols.v1.models.publish.PublishMavenCoordinates;
import com.gradle.publish.protocols.v1.models.publish.PublishNewVersionRequest;
import com.gradle.publish.protocols.v1.models.publish.PublishNewVersionResponse;
import com.gradle.publish.protocols.v1.models.publish.ValidateNewVersionRequest;
import com.gradle.publish.protocols.v1.models.publish.ValidateNewVersionResponse;
import com.gradle.publish.upload.Uploader;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

class PortalPublisher {
    private static final Logger LOGGER = Logging.getLogger(PublishTask.class);
    private final Config ghConfig;
    private final Project project;

    PortalPublisher(Project project) {
        this.project = project;
        this.ghConfig = new Config(project);
    }

    void publishToPortal(List<PublishNewVersionRequest> requests, PublishMavenCoordinates mavenCoords, Map<PublishArtifact, File> artifacts) throws Exception {
        ArrayList<PublishNewVersionResponse> apiResponses = new ArrayList<PublishNewVersionResponse>();
        for (PublishNewVersionRequest request : requests) {
            LOGGER.lifecycle("Publishing plugin {} version {}", new Object[]{request.getPluginId(), request.getPluginVersion()});
            request.setMavenCoordinates(mavenCoords);
            request.setArtifacts(new ArrayList<PublishArtifact>(artifacts.keySet()));
            PublishNewVersionResponse apiResponse = this.doSignedPost(request);
            this.handleApiResponse(request.getPluginId(), apiResponse);
            apiResponses.add(apiResponse);
        }
        LOGGER.debug("Uploading artifacts");
        this.publishArtifacts((PublishNewVersionResponse)apiResponses.get(0), artifacts);
        for (PublishNewVersionResponse apiResponse : apiResponses) {
            this.activate(apiResponse.getNextRequest());
        }
    }

    void validatePublishingToPortal(List<ValidateNewVersionRequest> requests, PublishMavenCoordinates mavenCoords, Map<PublishArtifact, File> artifacts) throws Exception {
        for (ValidateNewVersionRequest request : requests) {
            LOGGER.lifecycle("Validating plugin publication of {} version {}", new Object[]{request.getPluginId(), request.getPluginVersion()});
            request.setMavenCoordinates(mavenCoords);
            request.setArtifacts(new ArrayList<PublishArtifact>(artifacts.keySet()));
            ValidateNewVersionResponse apiResponse = this.doSignedPost(request);
            this.handleValidationResponse(request.getPluginId(), apiResponse);
        }
    }

    private <T extends ServerResponseBase> T doSignedPost(ClientPostRequest<T> postRequest) throws Exception {
        return this.buildOAuthClient().send(postRequest);
    }

    private OAuthHttpClient buildOAuthClient() {
        Properties props = this.createPropertiesStore();
        String key = this.getEnvThenSystemProperty("GRADLE_PUBLISH_KEY", props, "gradle.publish.key");
        String secret = this.getEnvThenSystemProperty("GRADLE_PUBLISH_SECRET", props, "gradle.publish.secret");
        if (key == null || key.trim().isEmpty() || secret == null || secret.trim().isEmpty()) {
            throw new IllegalArgumentException("Missing publishing keys. Please set gradle.publish.key/gradle.publish.secret system properties or GRADLE_PUBLISH_KEY/GRADLE_PUBLISH_SECRET env variables or login using the login task.");
        }
        return new OAuthHttpClient(this.ghConfig.getPortalUrl(), key, secret);
    }

    private Properties createPropertiesStore() {
        return PropertiesStore.all(this.project);
    }

    private String getEnvThenSystemProperty(String envName, Properties properties, String propertyName) {
        String envValue = System.getenv(envName);
        if (envValue == null) {
            return properties.getProperty(propertyName);
        }
        return envValue;
    }

    private void handleApiResponse(String pluginId, PublishNewVersionResponse apiResponse) {
        ResponseUtil.assertValidResponse("Request to publish new plugin '" + pluginId + "' failed!", apiResponse);
        if (apiResponse.hasFailed().booleanValue()) {
            throw new RuntimeException("Cannot publish plugin '" + pluginId + "'\nServer responded with: " + apiResponse.getErrorMessage());
        }
        if (apiResponse.hasWarning().booleanValue()) {
            LOGGER.warn(apiResponse.getWarningMessage());
        }
    }

    private void handleValidationResponse(String pluginId, ValidateNewVersionResponse apiResponse) {
        ResponseUtil.assertValidResponse("Request to publish new plugin '" + pluginId + "' failed!", apiResponse);
        if (apiResponse.hasFailed().booleanValue()) {
            throw new RuntimeException("Cannot publish plugin '" + pluginId + "'\nServer responded with: " + apiResponse.getErrorMessage());
        }
    }

    private void publishArtifacts(PublishNewVersionResponse apiResponse, Map<PublishArtifact, File> artifactHashes) throws IOException {
        Map<String, String> publishedHashAndUrls = apiResponse.getPublishTo();
        for (Map.Entry<PublishArtifact, File> art : artifactHashes.entrySet()) {
            String uploadUrl = publishedHashAndUrls.get(art.getKey().encode());
            File artifactFile = art.getValue();
            this.uploadArtifactIfNecessary(artifactFile, uploadUrl);
        }
    }

    private void uploadArtifactIfNecessary(File artifactFile, String uploadUrl) throws IOException {
        URI filePath = this.project.getProjectDir().toURI().relativize(artifactFile.toURI());
        if (uploadUrl != null) {
            LOGGER.lifecycle("Publishing artifact {}", new Object[]{filePath});
            LOGGER.debug("Publishing {} to {}", (Object)filePath, (Object)uploadUrl);
            Uploader.putFile(artifactFile, uploadUrl);
        } else {
            LOGGER.info("Skipping upload of artifact {} as it has been previously uploaded", (Object)filePath);
        }
    }

    private void activate(PublishActivateRequest activePlugin) throws Exception {
        LOGGER.lifecycle("Activating plugin {} version {}", new Object[]{activePlugin.getPluginId(), activePlugin.getVersion()});
        this.doSignedPost(activePlugin);
    }
}

