/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.publish;

import com.gradle.publish.InvalidPluginIdException;
import com.gradle.publish.PluginBundleExtension;
import com.gradle.publish.PluginId;
import com.gradle.publish.Util;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.regex.Pattern;
import org.gradle.plugin.devel.GradlePluginDevelopmentExtension;
import org.gradle.plugin.devel.PluginDeclaration;

public class PluginPublishValidator {
    private static final Collection<String> FORBIDDEN_NAMESPACES = Collections.unmodifiableList(Arrays.asList("org.gradle", "com.gradleware", "com.gradle", "org.samples.greeting"));
    private final boolean skipNamespaceCheck;
    private static final Pattern MAVEN_ID_REGEX = Pattern.compile("[A-Za-z0-9_\\-.]+");

    public PluginPublishValidator(boolean skipNamespaceCheck) {
        this.skipNamespaceCheck = skipNamespaceCheck;
    }

    public void validateMavenCoordinates(String groupId, String artifactId, String version) {
        if (Util.isBlank(groupId)) {
            throw new IllegalArgumentException("Cannot publish artifacts as no group ID set.\nPlease set the group at the project level.");
        }
        if (!MAVEN_ID_REGEX.matcher(groupId).matches()) {
            throw new IllegalArgumentException("Cannot publish artifacts as group ID '" + groupId + "' is invalid.\nValid group IDs may include alphanumeric characters, numbers, dashes,\nunderscores and dots.");
        }
        if (this.failsNamespaceCheck(groupId)) {
            throw new IllegalArgumentException("Cannot publish artifacts as group ID '" + groupId + "' is not allowed.\nGroup IDs cannot begin with " + String.join((CharSequence)", ", FORBIDDEN_NAMESPACES));
        }
        if (!MAVEN_ID_REGEX.matcher(artifactId).matches()) {
            throw new IllegalArgumentException("Cannot publish artifacts as artifact ID '" + artifactId + "' is invalid.\nValid artifact IDs may include alphanumeric characters, numbers, dashes,\nunderscores and dots.");
        }
        if (artifactId.equals(groupId + ".gradle.plugin")) {
            throw new IllegalArgumentException("Group ID + '.gradle.plugin' suffix not allowed as artifact ID");
        }
        if (Util.isBlank(version) || version.equals("unspecified")) {
            throw new IllegalArgumentException("Cannot publish artifacts as no version set.\nPlease set the version at the project level.");
        }
    }

    public void validateBundle(PluginBundleExtension bundleConfig, GradlePluginDevelopmentExtension pluginConfig) {
        if (pluginConfig.getPlugins().isEmpty()) {
            throw new IllegalArgumentException("No plugins defined. Please declare at least one plugin in a pluginBundle plugins block");
        }
        this.validateURL(bundleConfig.getWebsite(), "website");
        this.validateURL(bundleConfig.getVcsUrl(), "VCS");
        this.validatePluginIdUniqueness(pluginConfig);
        for (PluginDeclaration plugin : pluginConfig.getPlugins()) {
            this.validatePluginConfig(bundleConfig, plugin);
        }
    }

    private void validateURL(String url, String description) {
        if (Util.isBlank(url)) {
            throw new IllegalArgumentException("Plugin bundle has no " + description + " URL set, please set the property in pluginBundle config.\nExample value: 'https://github.com/username/repo'");
        }
        try {
            URI normalizedURI = new URI(url.toLowerCase());
            String scheme = normalizedURI.getScheme();
            if (!scheme.equals("http") && !scheme.equals("https")) {
                throw new IllegalArgumentException("Plugin bundle " + description + " URL only supports HTTP or HTTPS schemas, please set the property in the pluginBundle config accordingly.\nExample value: 'https://github.com/username/repo'");
            }
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Can't parse URL '" + url + "'");
        }
    }

    private void validateTags(PluginBundleExtension bundleConfig, PluginDeclaration plugin) {
        Collection<String> tags = Util.getTags(bundleConfig, plugin);
        if (tags.isEmpty()) {
            throw new IllegalArgumentException("No tags specified for plugin " + plugin.getName() + ", please set the tags property in the pluginBundle config.\nExample:\n\tplugin tags {\n\t\t" + plugin.getName() + " = ['test', 'integration']\n\t}\nAlternatively set global tags for all plugins defined in the bundle:\n\ttags = ['test', 'integration']");
        }
    }

    public void validatePluginConfig(PluginBundleExtension bundleConfig, PluginDeclaration plugin) {
        String pluginName = plugin.getName();
        this.validatePluginId(pluginName, plugin.getId());
        if (Util.isBlank(plugin.getDisplayName())) {
            throw new IllegalArgumentException("Plugin " + plugin.getName() + " has no display name, please set the displayName property in the plugin declaration.\nExample: displayName = 'My Widget Plugin'");
        }
        String desc = plugin.getDescription();
        String string = desc = desc != null ? desc : bundleConfig.getDescription();
        if (Util.isBlank(desc)) {
            throw new IllegalArgumentException("Plugin " + plugin.getName() + " has no description, please set the description property\nin the plugin declaration or the pluginBundle config.\nExample: description = 'This plugin adds some tasks and makes you coffee'");
        }
        this.validateTags(bundleConfig, plugin);
    }

    private void validatePluginId(String pluginName, String pluginId) {
        if (pluginId == null || pluginId.isEmpty()) {
            throw new IllegalArgumentException("Plugin " + pluginName + " does not define a plugin ID. Please set the 'id' property in the plugin declaration");
        }
        PluginId id = PluginId.of(pluginId);
        if (!id.isQualified()) {
            throw new InvalidPluginIdException(pluginId, "Plugin IDs should be namespaced, e.g. 'com.example." + pluginId + "'");
        }
        if (this.failsNamespaceCheck(pluginId)) {
            throw new InvalidPluginIdException(pluginId, "cannot begin with " + FORBIDDEN_NAMESPACES);
        }
    }

    private void validatePluginIdUniqueness(GradlePluginDevelopmentExtension pluginConfig) {
        HashSet<String> usedPluginIds = new HashSet<String>();
        for (PluginDeclaration plugin : pluginConfig.getPlugins()) {
            String pluginId = plugin.getId();
            if (usedPluginIds.contains(pluginId)) {
                throw new InvalidPluginIdException(pluginId, "multiple plugins are using the same ID");
            }
            usedPluginIds.add(pluginId);
        }
    }

    private boolean failsNamespaceCheck(String id) {
        if (!this.skipNamespaceCheck) {
            id = id.toLowerCase();
            for (String ns : FORBIDDEN_NAMESPACES) {
                if (!id.equals(ns) && !id.startsWith(ns + ".")) continue;
                return true;
            }
        }
        return false;
    }
}

